/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTask implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationTask.Builder, ReplicationTask> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::replicationTaskIdentifier)).setter(setter(Builder::replicationTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::sourceEndpointArn)).setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::targetEndpointArn)).setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::replicationInstanceArn)).setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::migrationTypeAsString)).setter(setter(Builder::migrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::tableMappings)).setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::replicationTaskSettings)).setter(setter(Builder::replicationTaskSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::lastFailureMessage)).setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final SdkField<String> STOP_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::stopReason)).setter(setter(Builder::stopReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopReason").build()).build();

    private static final SdkField<Instant> REPLICATION_TASK_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReplicationTask::replicationTaskCreationDate))
            .setter(setter(Builder::replicationTaskCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskCreationDate")
                    .build()).build();

    private static final SdkField<Instant> REPLICATION_TASK_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(ReplicationTask::replicationTaskStartDate))
            .setter(setter(Builder::replicationTaskStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskStartDate").build())
            .build();

    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::cdcStartPosition)).setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::cdcStopPosition)).setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final SdkField<String> RECOVERY_CHECKPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::recoveryCheckpoint)).setter(setter(Builder::recoveryCheckpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryCheckpoint").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationTask::replicationTaskArn)).setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<ReplicationTaskStats> REPLICATION_TASK_STATS_FIELD = SdkField
            .<ReplicationTaskStats> builder(MarshallingType.SDK_POJO).getter(getter(ReplicationTask::replicationTaskStats))
            .setter(setter(Builder::replicationTaskStats)).constructor(ReplicationTaskStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskStats").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_TASK_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD,
            REPLICATION_INSTANCE_ARN_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD,
            STATUS_FIELD, LAST_FAILURE_MESSAGE_FIELD, STOP_REASON_FIELD, REPLICATION_TASK_CREATION_DATE_FIELD,
            REPLICATION_TASK_START_DATE_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD, RECOVERY_CHECKPOINT_FIELD,
            REPLICATION_TASK_ARN_FIELD, REPLICATION_TASK_STATS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationTaskIdentifier;

    private final String sourceEndpointArn;

    private final String targetEndpointArn;

    private final String replicationInstanceArn;

    private final String migrationType;

    private final String tableMappings;

    private final String replicationTaskSettings;

    private final String status;

    private final String lastFailureMessage;

    private final String stopReason;

    private final Instant replicationTaskCreationDate;

    private final Instant replicationTaskStartDate;

    private final String cdcStartPosition;

    private final String cdcStopPosition;

    private final String recoveryCheckpoint;

    private final String replicationTaskArn;

    private final ReplicationTaskStats replicationTaskStats;

    private ReplicationTask(BuilderImpl builder) {
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.status = builder.status;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.stopReason = builder.stopReason;
        this.replicationTaskCreationDate = builder.replicationTaskCreationDate;
        this.replicationTaskStartDate = builder.replicationTaskStartDate;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.recoveryCheckpoint = builder.recoveryCheckpoint;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskStats = builder.replicationTaskStats;
    }

    /**
     * <p>
     * The user-assigned replication task identifier or name.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The user-assigned replication task identifier or name.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String replicationTaskIdentifier() {
        return replicationTaskIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public String targetEndpointArn() {
        return targetEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The type of migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The type of migration.
     * @see MigrationTypeValue
     */
    public MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(migrationType);
    }

    /**
     * <p>
     * The type of migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The type of migration.
     * @see MigrationTypeValue
     */
    public String migrationTypeAsString() {
        return migrationType;
    }

    /**
     * <p>
     * Table mappings specified in the task.
     * </p>
     * 
     * @return Table mappings specified in the task.
     */
    public String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * The settings for the replication task.
     * </p>
     * 
     * @return The settings for the replication task.
     */
    public String replicationTaskSettings() {
        return replicationTaskSettings;
    }

    /**
     * <p>
     * The status of the replication task.
     * </p>
     * 
     * @return The status of the replication task.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The last error (failure) message generated for the replication instance.
     * </p>
     * 
     * @return The last error (failure) message generated for the replication instance.
     */
    public String lastFailureMessage() {
        return lastFailureMessage;
    }

    /**
     * <p>
     * The reason the replication task was stopped.
     * </p>
     * 
     * @return The reason the replication task was stopped.
     */
    public String stopReason() {
        return stopReason;
    }

    /**
     * <p>
     * The date the replication task was created.
     * </p>
     * 
     * @return The date the replication task was created.
     */
    public Instant replicationTaskCreationDate() {
        return replicationTaskCreationDate;
    }

    /**
     * <p>
     * The date the replication task is scheduled to start.
     * </p>
     * 
     * @return The date the replication task is scheduled to start.
     */
    public Instant replicationTaskStartDate() {
        return replicationTaskStartDate;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. Use either <code>CdcStartPosition</code>
     * or <code>CdcStartTime</code> to specify when you want the CDC operation to start. Specifying both values results
     * in an error.
     * </p>
     * <p>
     * The value can be in date, checkpoint, or LSN/SCN format.
     * </p>
     * <p>
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     * </p>
     * <p>
     * Checkpoint Example: --cdc-start-position
     * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     * </p>
     * <p>
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. Use either
     *         <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to
     *         start. Specifying both values results in an error.</p>
     *         <p>
     *         The value can be in date, checkpoint, or LSN/SCN format.
     *         </p>
     *         <p>
     *         Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *         </p>
     *         <p>
     *         Checkpoint Example: --cdc-start-position
     *         "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *         </p>
     *         <p>
     *         LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     */
    public String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
     * commit time.
     * </p>
     * <p>
     * Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
     * </p>
     * <p>
     * Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
     *         time or commit time.</p>
     *         <p>
     *         Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
     *         </p>
     *         <p>
     *         Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
     */
    public String cdcStopPosition() {
        return cdcStopPosition;
    }

    /**
     * <p>
     * Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide this
     * value to the <code>CdcStartPosition</code> parameter to start a CDC operation that begins at that checkpoint.
     * </p>
     * 
     * @return Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide
     *         this value to the <code>CdcStartPosition</code> parameter to start a CDC operation that begins at that
     *         checkpoint.
     */
    public String recoveryCheckpoint() {
        return recoveryCheckpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * The statistics for the task, including elapsed time, tables loaded, and table errors.
     * </p>
     * 
     * @return The statistics for the task, including elapsed time, tables loaded, and table errors.
     */
    public ReplicationTaskStats replicationTaskStats() {
        return replicationTaskStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stopReason());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskStats());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTask)) {
            return false;
        }
        ReplicationTask other = (ReplicationTask) obj;
        return Objects.equals(replicationTaskIdentifier(), other.replicationTaskIdentifier())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(migrationTypeAsString(), other.migrationTypeAsString())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationTaskSettings(), other.replicationTaskSettings())
                && Objects.equals(status(), other.status()) && Objects.equals(lastFailureMessage(), other.lastFailureMessage())
                && Objects.equals(stopReason(), other.stopReason())
                && Objects.equals(replicationTaskCreationDate(), other.replicationTaskCreationDate())
                && Objects.equals(replicationTaskStartDate(), other.replicationTaskStartDate())
                && Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition())
                && Objects.equals(recoveryCheckpoint(), other.recoveryCheckpoint())
                && Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(replicationTaskStats(), other.replicationTaskStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationTask").add("ReplicationTaskIdentifier", replicationTaskIdentifier())
                .add("SourceEndpointArn", sourceEndpointArn()).add("TargetEndpointArn", targetEndpointArn())
                .add("ReplicationInstanceArn", replicationInstanceArn()).add("MigrationType", migrationTypeAsString())
                .add("TableMappings", tableMappings()).add("ReplicationTaskSettings", replicationTaskSettings())
                .add("Status", status()).add("LastFailureMessage", lastFailureMessage()).add("StopReason", stopReason())
                .add("ReplicationTaskCreationDate", replicationTaskCreationDate())
                .add("ReplicationTaskStartDate", replicationTaskStartDate()).add("CdcStartPosition", cdcStartPosition())
                .add("CdcStopPosition", cdcStopPosition()).add("RecoveryCheckpoint", recoveryCheckpoint())
                .add("ReplicationTaskArn", replicationTaskArn()).add("ReplicationTaskStats", replicationTaskStats()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskIdentifier":
            return Optional.ofNullable(clazz.cast(replicationTaskIdentifier()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "MigrationType":
            return Optional.ofNullable(clazz.cast(migrationTypeAsString()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationTaskSettings":
            return Optional.ofNullable(clazz.cast(replicationTaskSettings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        case "StopReason":
            return Optional.ofNullable(clazz.cast(stopReason()));
        case "ReplicationTaskCreationDate":
            return Optional.ofNullable(clazz.cast(replicationTaskCreationDate()));
        case "ReplicationTaskStartDate":
            return Optional.ofNullable(clazz.cast(replicationTaskStartDate()));
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        case "RecoveryCheckpoint":
            return Optional.ofNullable(clazz.cast(recoveryCheckpoint()));
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ReplicationTaskStats":
            return Optional.ofNullable(clazz.cast(replicationTaskStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTask, T> g) {
        return obj -> g.apply((ReplicationTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTask> {
        /**
         * <p>
         * The user-assigned replication task identifier or name.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationTaskIdentifier
         *        The user-assigned replication task identifier or name.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIdentifier(String replicationTaskIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * </p>
         * 
         * @param sourceEndpointArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * </p>
         * 
         * @param targetEndpointArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The type of migration.
         * </p>
         * 
         * @param migrationType
         *        The type of migration.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(String migrationType);

        /**
         * <p>
         * The type of migration.
         * </p>
         * 
         * @param migrationType
         *        The type of migration.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(MigrationTypeValue migrationType);

        /**
         * <p>
         * Table mappings specified in the task.
         * </p>
         * 
         * @param tableMappings
         *        Table mappings specified in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * The settings for the replication task.
         * </p>
         * 
         * @param replicationTaskSettings
         *        The settings for the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskSettings(String replicationTaskSettings);

        /**
         * <p>
         * The status of the replication task.
         * </p>
         * 
         * @param status
         *        The status of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The last error (failure) message generated for the replication instance.
         * </p>
         * 
         * @param lastFailureMessage
         *        The last error (failure) message generated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);

        /**
         * <p>
         * The reason the replication task was stopped.
         * </p>
         * 
         * @param stopReason
         *        The reason the replication task was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopReason(String stopReason);

        /**
         * <p>
         * The date the replication task was created.
         * </p>
         * 
         * @param replicationTaskCreationDate
         *        The date the replication task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskCreationDate(Instant replicationTaskCreationDate);

        /**
         * <p>
         * The date the replication task is scheduled to start.
         * </p>
         * 
         * @param replicationTaskStartDate
         *        The date the replication task is scheduled to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskStartDate(Instant replicationTaskStartDate);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. Use either
         * <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to
         * start. Specifying both values results in an error.
         * </p>
         * <p>
         * The value can be in date, checkpoint, or LSN/SCN format.
         * </p>
         * <p>
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         * </p>
         * <p>
         * Checkpoint Example: --cdc-start-position
         * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         * </p>
         * <p>
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         * </p>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. Use either
         *        <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation
         *        to start. Specifying both values results in an error.</p>
         *        <p>
         *        The value can be in date, checkpoint, or LSN/SCN format.
         *        </p>
         *        <p>
         *        Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *        </p>
         *        <p>
         *        Checkpoint Example: --cdc-start-position
         *        "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *        </p>
         *        <p>
         *        LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
         * commit time.
         * </p>
         * <p>
         * Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
         * </p>
         * <p>
         * Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
         *        time or commit time.</p>
         *        <p>
         *        Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
         *        </p>
         *        <p>
         *        Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        /**
         * <p>
         * Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide
         * this value to the <code>CdcStartPosition</code> parameter to start a CDC operation that begins at that
         * checkpoint.
         * </p>
         * 
         * @param recoveryCheckpoint
         *        Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can
         *        provide this value to the <code>CdcStartPosition</code> parameter to start a CDC operation that begins
         *        at that checkpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryCheckpoint(String recoveryCheckpoint);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The statistics for the task, including elapsed time, tables loaded, and table errors.
         * </p>
         * 
         * @param replicationTaskStats
         *        The statistics for the task, including elapsed time, tables loaded, and table errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskStats(ReplicationTaskStats replicationTaskStats);

        /**
         * <p>
         * The statistics for the task, including elapsed time, tables loaded, and table errors.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplicationTaskStats.Builder} avoiding the need
         * to create one manually via {@link ReplicationTaskStats#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationTaskStats.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationTaskStats(ReplicationTaskStats)}.
         * 
         * @param replicationTaskStats
         *        a consumer that will call methods on {@link ReplicationTaskStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTaskStats(ReplicationTaskStats)
         */
        default Builder replicationTaskStats(Consumer<ReplicationTaskStats.Builder> replicationTaskStats) {
            return replicationTaskStats(ReplicationTaskStats.builder().applyMutation(replicationTaskStats).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String replicationTaskIdentifier;

        private String sourceEndpointArn;

        private String targetEndpointArn;

        private String replicationInstanceArn;

        private String migrationType;

        private String tableMappings;

        private String replicationTaskSettings;

        private String status;

        private String lastFailureMessage;

        private String stopReason;

        private Instant replicationTaskCreationDate;

        private Instant replicationTaskStartDate;

        private String cdcStartPosition;

        private String cdcStopPosition;

        private String recoveryCheckpoint;

        private String replicationTaskArn;

        private ReplicationTaskStats replicationTaskStats;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTask model) {
            replicationTaskIdentifier(model.replicationTaskIdentifier);
            sourceEndpointArn(model.sourceEndpointArn);
            targetEndpointArn(model.targetEndpointArn);
            replicationInstanceArn(model.replicationInstanceArn);
            migrationType(model.migrationType);
            tableMappings(model.tableMappings);
            replicationTaskSettings(model.replicationTaskSettings);
            status(model.status);
            lastFailureMessage(model.lastFailureMessage);
            stopReason(model.stopReason);
            replicationTaskCreationDate(model.replicationTaskCreationDate);
            replicationTaskStartDate(model.replicationTaskStartDate);
            cdcStartPosition(model.cdcStartPosition);
            cdcStopPosition(model.cdcStopPosition);
            recoveryCheckpoint(model.recoveryCheckpoint);
            replicationTaskArn(model.replicationTaskArn);
            replicationTaskStats(model.replicationTaskStats);
        }

        public final String getReplicationTaskIdentifier() {
            return replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getMigrationTypeAsString() {
            return migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        public final String getReplicationTaskSettings() {
            return replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public final String getStopReason() {
            return stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        public final Instant getReplicationTaskCreationDate() {
            return replicationTaskCreationDate;
        }

        @Override
        public final Builder replicationTaskCreationDate(Instant replicationTaskCreationDate) {
            this.replicationTaskCreationDate = replicationTaskCreationDate;
            return this;
        }

        public final void setReplicationTaskCreationDate(Instant replicationTaskCreationDate) {
            this.replicationTaskCreationDate = replicationTaskCreationDate;
        }

        public final Instant getReplicationTaskStartDate() {
            return replicationTaskStartDate;
        }

        @Override
        public final Builder replicationTaskStartDate(Instant replicationTaskStartDate) {
            this.replicationTaskStartDate = replicationTaskStartDate;
            return this;
        }

        public final void setReplicationTaskStartDate(Instant replicationTaskStartDate) {
            this.replicationTaskStartDate = replicationTaskStartDate;
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        public final String getRecoveryCheckpoint() {
            return recoveryCheckpoint;
        }

        @Override
        public final Builder recoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
            return this;
        }

        public final void setRecoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final ReplicationTaskStats.Builder getReplicationTaskStats() {
            return replicationTaskStats != null ? replicationTaskStats.toBuilder() : null;
        }

        @Override
        public final Builder replicationTaskStats(ReplicationTaskStats replicationTaskStats) {
            this.replicationTaskStats = replicationTaskStats;
            return this;
        }

        public final void setReplicationTaskStats(ReplicationTaskStats.BuilderImpl replicationTaskStats) {
            this.replicationTaskStats = replicationTaskStats != null ? replicationTaskStats.build() : null;
        }

        @Override
        public ReplicationTask build() {
            return new ReplicationTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
