/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshSchemasStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshSchemasStatus.Builder, RefreshSchemasStatus> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RefreshSchemasStatus::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RefreshSchemasStatus::replicationInstanceArn)).setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RefreshSchemasStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_REFRESH_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RefreshSchemasStatus::lastRefreshDate)).setter(setter(Builder::lastRefreshDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshDate").build()).build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RefreshSchemasStatus::lastFailureMessage)).setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            REPLICATION_INSTANCE_ARN_FIELD, STATUS_FIELD, LAST_REFRESH_DATE_FIELD, LAST_FAILURE_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointArn;

    private final String replicationInstanceArn;

    private final String status;

    private final Instant lastRefreshDate;

    private final String lastFailureMessage;

    private RefreshSchemasStatus(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.status = builder.status;
        this.lastRefreshDate = builder.lastRefreshDate;
        this.lastFailureMessage = builder.lastFailureMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RefreshSchemasStatusTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see RefreshSchemasStatusTypeValue
     */
    public RefreshSchemasStatusTypeValue status() {
        return RefreshSchemasStatusTypeValue.fromValue(status);
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RefreshSchemasStatusTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema.
     * @see RefreshSchemasStatusTypeValue
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date the schema was last refreshed.
     * </p>
     * 
     * @return The date the schema was last refreshed.
     */
    public Instant lastRefreshDate() {
        return lastRefreshDate;
    }

    /**
     * <p>
     * The last failure message for the schema.
     * </p>
     * 
     * @return The last failure message for the schema.
     */
    public String lastFailureMessage() {
        return lastFailureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshSchemasStatus)) {
            return false;
        }
        RefreshSchemasStatus other = (RefreshSchemasStatus) obj;
        return Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastRefreshDate(), other.lastRefreshDate())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RefreshSchemasStatus").add("EndpointArn", endpointArn())
                .add("ReplicationInstanceArn", replicationInstanceArn()).add("Status", statusAsString())
                .add("LastRefreshDate", lastRefreshDate()).add("LastFailureMessage", lastFailureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastRefreshDate":
            return Optional.ofNullable(clazz.cast(lastRefreshDate()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshSchemasStatus, T> g) {
        return obj -> g.apply((RefreshSchemasStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshSchemasStatus> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param status
         *        The status of the schema.
         * @see RefreshSchemasStatusTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshSchemasStatusTypeValue
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param status
         *        The status of the schema.
         * @see RefreshSchemasStatusTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshSchemasStatusTypeValue
         */
        Builder status(RefreshSchemasStatusTypeValue status);

        /**
         * <p>
         * The date the schema was last refreshed.
         * </p>
         * 
         * @param lastRefreshDate
         *        The date the schema was last refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshDate(Instant lastRefreshDate);

        /**
         * <p>
         * The last failure message for the schema.
         * </p>
         * 
         * @param lastFailureMessage
         *        The last failure message for the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String endpointArn;

        private String replicationInstanceArn;

        private String status;

        private Instant lastRefreshDate;

        private String lastFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshSchemasStatus model) {
            endpointArn(model.endpointArn);
            replicationInstanceArn(model.replicationInstanceArn);
            status(model.status);
            lastRefreshDate(model.lastRefreshDate);
            lastFailureMessage(model.lastFailureMessage);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RefreshSchemasStatusTypeValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastRefreshDate() {
            return lastRefreshDate;
        }

        @Override
        public final Builder lastRefreshDate(Instant lastRefreshDate) {
            this.lastRefreshDate = lastRefreshDate;
            return this;
        }

        public final void setLastRefreshDate(Instant lastRefreshDate) {
            this.lastRefreshDate = lastRefreshDate;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public RefreshSchemasStatus build() {
            return new RefreshSchemasStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
