/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftSettings.Builder, RedshiftSettings> {
    private static final SdkField<Boolean> ACCEPT_ANY_DATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RedshiftSettings::acceptAnyDate)).setter(setter(Builder::acceptAnyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptAnyDate").build()).build();

    private static final SdkField<String> AFTER_CONNECT_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::afterConnectScript)).setter(setter(Builder::afterConnectScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterConnectScript").build())
            .build();

    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::bucketFolder)).setter(setter(Builder::bucketFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<Integer> CONNECTION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftSettings::connectionTimeout)).setter(setter(Builder::connectionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeout").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::dateFormat)).setter(setter(Builder::dateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFormat").build()).build();

    private static final SdkField<Boolean> EMPTY_AS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RedshiftSettings::emptyAsNull)).setter(setter(Builder::emptyAsNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyAsNull").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::encryptionModeAsString)).setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<Integer> FILE_TRANSFER_UPLOAD_STREAMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(RedshiftSettings::fileTransferUploadStreams))
            .setter(setter(Builder::fileTransferUploadStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileTransferUploadStreams").build())
            .build();

    private static final SdkField<Integer> LOAD_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftSettings::loadTimeout)).setter(setter(Builder::loadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadTimeout").build()).build();

    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftSettings::maxFileSize)).setter(setter(Builder::maxFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> REMOVE_QUOTES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RedshiftSettings::removeQuotes)).setter(setter(Builder::removeQuotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveQuotes").build()).build();

    private static final SdkField<String> REPLACE_INVALID_CHARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::replaceInvalidChars)).setter(setter(Builder::replaceInvalidChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceInvalidChars").build())
            .build();

    private static final SdkField<String> REPLACE_CHARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::replaceChars)).setter(setter(Builder::replaceChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceChars").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::serverSideEncryptionKmsKeyId))
            .setter(setter(Builder::serverSideEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId")
                    .build()).build();

    private static final SdkField<String> TIME_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::timeFormat)).setter(setter(Builder::timeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeFormat").build()).build();

    private static final SdkField<Boolean> TRIM_BLANKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RedshiftSettings::trimBlanks)).setter(setter(Builder::trimBlanks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimBlanks").build()).build();

    private static final SdkField<Boolean> TRUNCATE_COLUMNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RedshiftSettings::truncateColumns)).setter(setter(Builder::truncateColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruncateColumns").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<Integer> WRITE_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftSettings::writeBufferSize)).setter(setter(Builder::writeBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteBufferSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_ANY_DATE_FIELD,
            AFTER_CONNECT_SCRIPT_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, CONNECTION_TIMEOUT_FIELD, DATABASE_NAME_FIELD,
            DATE_FORMAT_FIELD, EMPTY_AS_NULL_FIELD, ENCRYPTION_MODE_FIELD, FILE_TRANSFER_UPLOAD_STREAMS_FIELD,
            LOAD_TIMEOUT_FIELD, MAX_FILE_SIZE_FIELD, PASSWORD_FIELD, PORT_FIELD, REMOVE_QUOTES_FIELD,
            REPLACE_INVALID_CHARS_FIELD, REPLACE_CHARS_FIELD, SERVER_NAME_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD,
            SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD, TIME_FORMAT_FIELD, TRIM_BLANKS_FIELD, TRUNCATE_COLUMNS_FIELD,
            USERNAME_FIELD, WRITE_BUFFER_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean acceptAnyDate;

    private final String afterConnectScript;

    private final String bucketFolder;

    private final String bucketName;

    private final Integer connectionTimeout;

    private final String databaseName;

    private final String dateFormat;

    private final Boolean emptyAsNull;

    private final String encryptionMode;

    private final Integer fileTransferUploadStreams;

    private final Integer loadTimeout;

    private final Integer maxFileSize;

    private final String password;

    private final Integer port;

    private final Boolean removeQuotes;

    private final String replaceInvalidChars;

    private final String replaceChars;

    private final String serverName;

    private final String serviceAccessRoleArn;

    private final String serverSideEncryptionKmsKeyId;

    private final String timeFormat;

    private final Boolean trimBlanks;

    private final Boolean truncateColumns;

    private final String username;

    private final Integer writeBufferSize;

    private RedshiftSettings(BuilderImpl builder) {
        this.acceptAnyDate = builder.acceptAnyDate;
        this.afterConnectScript = builder.afterConnectScript;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.connectionTimeout = builder.connectionTimeout;
        this.databaseName = builder.databaseName;
        this.dateFormat = builder.dateFormat;
        this.emptyAsNull = builder.emptyAsNull;
        this.encryptionMode = builder.encryptionMode;
        this.fileTransferUploadStreams = builder.fileTransferUploadStreams;
        this.loadTimeout = builder.loadTimeout;
        this.maxFileSize = builder.maxFileSize;
        this.password = builder.password;
        this.port = builder.port;
        this.removeQuotes = builder.removeQuotes;
        this.replaceInvalidChars = builder.replaceInvalidChars;
        this.replaceChars = builder.replaceChars;
        this.serverName = builder.serverName;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.timeFormat = builder.timeFormat;
        this.trimBlanks = builder.trimBlanks;
        this.truncateColumns = builder.truncateColumns;
        this.username = builder.username;
        this.writeBufferSize = builder.writeBufferSize;
    }

    /**
     * <p>
     * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be
     * loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the default).
     * </p>
     * <p>
     * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
     * parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a
     * NULL value into that field.
     * </p>
     * 
     * @return A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to
     *         be loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the
     *         default).</p>
     *         <p>
     *         This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
     *         parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift
     *         inserts a NULL value into that field.
     */
    public Boolean acceptAnyDate() {
        return acceptAnyDate;
    }

    /**
     * <p>
     * Code to run after connecting. This parameter should contain the code itself, not the name of a file containing
     * the code.
     * </p>
     * 
     * @return Code to run after connecting. This parameter should contain the code itself, not the name of a file
     *         containing the code.
     */
    public String afterConnectScript() {
        return afterConnectScript;
    }

    /**
     * <p>
     * The location where the comma-separated value (.csv) files are stored before being uploaded to the S3 bucket.
     * </p>
     * 
     * @return The location where the comma-separated value (.csv) files are stored before being uploaded to the S3
     *         bucket.
     */
    public String bucketFolder() {
        return bucketFolder;
    }

    /**
     * <p>
     * The name of the S3 bucket you want to use
     * </p>
     * 
     * @return The name of the S3 bucket you want to use
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
     * initially establish a connection.
     * </p>
     * 
     * @return A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
     *         initially establish a connection.
     */
    public Integer connectionTimeout() {
        return connectionTimeout;
    }

    /**
     * <p>
     * The name of the Amazon Redshift data warehouse (service) that you are working with.
     * </p>
     * 
     * @return The name of the Amazon Redshift data warehouse (service) that you are working with.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format string
     * enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'.
     * Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a date format
     * string.
     * </p>
     * <p>
     * If your date and time values use formats different from each other, set this to <code>auto</code>.
     * </p>
     * 
     * @return The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format
     *         string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of
     *         'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you
     *         use a date format string. </p>
     *         <p>
     *         If your date and time values use formats different from each other, set this to <code>auto</code>.
     */
    public String dateFormat() {
        return dateFormat;
    }

    /**
     * <p>
     * A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
     * <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
     *         <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
     */
    public Boolean emptyAsNull() {
        return emptyAsNull;
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS Identity and Access Management
     * (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
     * <code>"s3:PutObject", "s3:ListBucket"</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS
     *         Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use
     *         the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * @see EncryptionModeValue
     */
    public EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS Identity and Access Management
     * (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
     * <code>"s3:PutObject", "s3:ListBucket"</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS
     *         Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use
     *         the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
     * @see EncryptionModeValue
     */
    public String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It defaults
     * to 10.
     * </p>
     * 
     * @return The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It
     *         defaults to 10.
     */
    public Integer fileTransferUploadStreams() {
        return fileTransferUploadStreams;
    }

    /**
     * <p>
     * The amount of time to wait (in milliseconds) before timing out, beginning from when you begin loading.
     * </p>
     * 
     * @return The amount of time to wait (in milliseconds) before timing out, beginning from when you begin loading.
     */
    public Integer loadTimeout() {
        return loadTimeout;
    }

    /**
     * <p>
     * The maximum size (in KB) of any .csv file used to transfer data to Amazon Redshift. This accepts a value from 1
     * through 1,048,576. It defaults to 32,768 KB (32 MB).
     * </p>
     * 
     * @return The maximum size (in KB) of any .csv file used to transfer data to Amazon Redshift. This accepts a value
     *         from 1 through 1,048,576. It defaults to 32,768 KB (32 MB).
     */
    public Integer maxFileSize() {
        return maxFileSize;
    }

    /**
     * <p>
     * The password for the user named in the <code>username</code> property.
     * </p>
     * 
     * @return The password for the user named in the <code>username</code> property.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The port number for Amazon Redshift. The default value is 5439.
     * </p>
     * 
     * @return The port number for Amazon Redshift. The default value is 5439.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All characters
     * within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation
     * marks. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
     *         characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to
     *         remove quotation marks. The default is <code>false</code>.
     */
    public Boolean removeQuotes() {
        return removeQuotes;
    }

    /**
     * <p>
     * A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
     * </p>
     * 
     * @return A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
     */
    public String replaceInvalidChars() {
        return replaceInvalidChars;
    }

    /**
     * <p>
     * A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
     * substituting the specified characters instead. The default is <code>"?"</code>.
     * </p>
     * 
     * @return A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
     *         substituting the specified characters instead. The default is <code>"?"</code>.
     */
    public String replaceChars() {
        return replaceChars;
    }

    /**
     * <p>
     * The name of the Amazon Redshift cluster you are using.
     * </p>
     * 
     * @return The name of the Amazon Redshift cluster you are using.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The AWS KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this key
     * ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
     * </p>
     * 
     * @return The AWS KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide
     *         this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows
     *         use of the key.
     */
    public String serverSideEncryptionKmsKeyId() {
        return serverSideEncryptionKmsKeyId;
    }

    /**
     * <p>
     * The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
     * <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults to 10.
     * Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time format
     * string.
     * </p>
     * <p>
     * If your date and time values use formats different from each other, set this parameter to <code>auto</code>.
     * </p>
     * 
     * @return The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
     *         <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults
     *         to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a
     *         time format string. </p>
     *         <p>
     *         If your date and time values use formats different from each other, set this parameter to
     *         <code>auto</code>.
     */
    public String timeFormat() {
        return timeFormat;
    }

    /**
     * <p>
     * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter
     * applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The
     * default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to remove the trailing white space characters from a VARCHAR string. This
     *         parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded
     *         white space. The default is <code>false</code>.
     */
    public Boolean trimBlanks() {
        return trimBlanks;
    }

    /**
     * <p>
     * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits
     * in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4
     * MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code>.
     * </p>
     * 
     * @return A value that specifies to truncate data in columns to the appropriate number of characters, so that the
     *         data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and
     *         rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is
     *         <code>false</code>.
     */
    public Boolean truncateColumns() {
        return truncateColumns;
    }

    /**
     * <p>
     * An Amazon Redshift user name for a registered user.
     * </p>
     * 
     * @return An Amazon Redshift user name for a registered user.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The size of the write buffer to use in rows. Valid values range from 1 through 2,048. The default is 1,024. Use
     * this setting to tune performance.
     * </p>
     * 
     * @return The size of the write buffer to use in rows. Valid values range from 1 through 2,048. The default is
     *         1,024. Use this setting to tune performance.
     */
    public Integer writeBufferSize() {
        return writeBufferSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptAnyDate());
        hashCode = 31 * hashCode + Objects.hashCode(afterConnectScript());
        hashCode = 31 * hashCode + Objects.hashCode(bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(emptyAsNull());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileTransferUploadStreams());
        hashCode = 31 * hashCode + Objects.hashCode(loadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(removeQuotes());
        hashCode = 31 * hashCode + Objects.hashCode(replaceInvalidChars());
        hashCode = 31 * hashCode + Objects.hashCode(replaceChars());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(timeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(trimBlanks());
        hashCode = 31 * hashCode + Objects.hashCode(truncateColumns());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(writeBufferSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSettings)) {
            return false;
        }
        RedshiftSettings other = (RedshiftSettings) obj;
        return Objects.equals(acceptAnyDate(), other.acceptAnyDate())
                && Objects.equals(afterConnectScript(), other.afterConnectScript())
                && Objects.equals(bucketFolder(), other.bucketFolder()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(connectionTimeout(), other.connectionTimeout())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(dateFormat(), other.dateFormat())
                && Objects.equals(emptyAsNull(), other.emptyAsNull())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(fileTransferUploadStreams(), other.fileTransferUploadStreams())
                && Objects.equals(loadTimeout(), other.loadTimeout()) && Objects.equals(maxFileSize(), other.maxFileSize())
                && Objects.equals(password(), other.password()) && Objects.equals(port(), other.port())
                && Objects.equals(removeQuotes(), other.removeQuotes())
                && Objects.equals(replaceInvalidChars(), other.replaceInvalidChars())
                && Objects.equals(replaceChars(), other.replaceChars()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId())
                && Objects.equals(timeFormat(), other.timeFormat()) && Objects.equals(trimBlanks(), other.trimBlanks())
                && Objects.equals(truncateColumns(), other.truncateColumns()) && Objects.equals(username(), other.username())
                && Objects.equals(writeBufferSize(), other.writeBufferSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RedshiftSettings").add("AcceptAnyDate", acceptAnyDate())
                .add("AfterConnectScript", afterConnectScript()).add("BucketFolder", bucketFolder())
                .add("BucketName", bucketName()).add("ConnectionTimeout", connectionTimeout())
                .add("DatabaseName", databaseName()).add("DateFormat", dateFormat()).add("EmptyAsNull", emptyAsNull())
                .add("EncryptionMode", encryptionModeAsString()).add("FileTransferUploadStreams", fileTransferUploadStreams())
                .add("LoadTimeout", loadTimeout()).add("MaxFileSize", maxFileSize())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Port", port())
                .add("RemoveQuotes", removeQuotes()).add("ReplaceInvalidChars", replaceInvalidChars())
                .add("ReplaceChars", replaceChars()).add("ServerName", serverName())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("ServerSideEncryptionKmsKeyId", serverSideEncryptionKmsKeyId()).add("TimeFormat", timeFormat())
                .add("TrimBlanks", trimBlanks()).add("TruncateColumns", truncateColumns()).add("Username", username())
                .add("WriteBufferSize", writeBufferSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptAnyDate":
            return Optional.ofNullable(clazz.cast(acceptAnyDate()));
        case "AfterConnectScript":
            return Optional.ofNullable(clazz.cast(afterConnectScript()));
        case "BucketFolder":
            return Optional.ofNullable(clazz.cast(bucketFolder()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "ConnectionTimeout":
            return Optional.ofNullable(clazz.cast(connectionTimeout()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DateFormat":
            return Optional.ofNullable(clazz.cast(dateFormat()));
        case "EmptyAsNull":
            return Optional.ofNullable(clazz.cast(emptyAsNull()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "FileTransferUploadStreams":
            return Optional.ofNullable(clazz.cast(fileTransferUploadStreams()));
        case "LoadTimeout":
            return Optional.ofNullable(clazz.cast(loadTimeout()));
        case "MaxFileSize":
            return Optional.ofNullable(clazz.cast(maxFileSize()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "RemoveQuotes":
            return Optional.ofNullable(clazz.cast(removeQuotes()));
        case "ReplaceInvalidChars":
            return Optional.ofNullable(clazz.cast(replaceInvalidChars()));
        case "ReplaceChars":
            return Optional.ofNullable(clazz.cast(replaceChars()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ServerSideEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionKmsKeyId()));
        case "TimeFormat":
            return Optional.ofNullable(clazz.cast(timeFormat()));
        case "TrimBlanks":
            return Optional.ofNullable(clazz.cast(trimBlanks()));
        case "TruncateColumns":
            return Optional.ofNullable(clazz.cast(truncateColumns()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "WriteBufferSize":
            return Optional.ofNullable(clazz.cast(writeBufferSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSettings, T> g) {
        return obj -> g.apply((RedshiftSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftSettings> {
        /**
         * <p>
         * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be
         * loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the default).
         * </p>
         * <p>
         * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT
         * parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift
         * inserts a NULL value into that field.
         * </p>
         * 
         * @param acceptAnyDate
         *        A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00,
         *        to be loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the
         *        default).</p>
         *        <p>
         *        This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the
         *        DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification,
         *        Amazon Redshift inserts a NULL value into that field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptAnyDate(Boolean acceptAnyDate);

        /**
         * <p>
         * Code to run after connecting. This parameter should contain the code itself, not the name of a file
         * containing the code.
         * </p>
         * 
         * @param afterConnectScript
         *        Code to run after connecting. This parameter should contain the code itself, not the name of a file
         *        containing the code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterConnectScript(String afterConnectScript);

        /**
         * <p>
         * The location where the comma-separated value (.csv) files are stored before being uploaded to the S3 bucket.
         * </p>
         * 
         * @param bucketFolder
         *        The location where the comma-separated value (.csv) files are stored before being uploaded to the S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketFolder(String bucketFolder);

        /**
         * <p>
         * The name of the S3 bucket you want to use
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket you want to use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you
         * initially establish a connection.
         * </p>
         * 
         * @param connectionTimeout
         *        A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when
         *        you initially establish a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTimeout(Integer connectionTimeout);

        /**
         * <p>
         * The name of the Amazon Redshift data warehouse (service) that you are working with.
         * </p>
         * 
         * @param databaseName
         *        The name of the Amazon Redshift data warehouse (service) that you are working with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format
         * string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of
         * 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a
         * date format string.
         * </p>
         * <p>
         * If your date and time values use formats different from each other, set this to <code>auto</code>.
         * </p>
         * 
         * @param dateFormat
         *        The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date
         *        format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a
         *        format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't
         *        supported when you use a date format string. </p>
         *        <p>
         *        If your date and time values use formats different from each other, set this to <code>auto</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFormat(String dateFormat);

        /**
         * <p>
         * A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of
         * <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
         * </p>
         * 
         * @param emptyAsNull
         *        A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL. A value
         *        of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyAsNull(Boolean emptyAsNull);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS Identity
         * and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following
         * actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * </p>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS
         *        Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to
         *        use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS Identity
         * and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following
         * actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * </p>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, create an AWS
         *        Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to
         *        use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(EncryptionModeValue encryptionMode);

        /**
         * <p>
         * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It
         * defaults to 10.
         * </p>
         * 
         * @param fileTransferUploadStreams
         *        The number of threads used to upload a single file. This parameter accepts a value from 1 through 64.
         *        It defaults to 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileTransferUploadStreams(Integer fileTransferUploadStreams);

        /**
         * <p>
         * The amount of time to wait (in milliseconds) before timing out, beginning from when you begin loading.
         * </p>
         * 
         * @param loadTimeout
         *        The amount of time to wait (in milliseconds) before timing out, beginning from when you begin loading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadTimeout(Integer loadTimeout);

        /**
         * <p>
         * The maximum size (in KB) of any .csv file used to transfer data to Amazon Redshift. This accepts a value from
         * 1 through 1,048,576. It defaults to 32,768 KB (32 MB).
         * </p>
         * 
         * @param maxFileSize
         *        The maximum size (in KB) of any .csv file used to transfer data to Amazon Redshift. This accepts a
         *        value from 1 through 1,048,576. It defaults to 32,768 KB (32 MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFileSize(Integer maxFileSize);

        /**
         * <p>
         * The password for the user named in the <code>username</code> property.
         * </p>
         * 
         * @param password
         *        The password for the user named in the <code>username</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The port number for Amazon Redshift. The default value is 5439.
         * </p>
         * 
         * @param port
         *        The port number for Amazon Redshift. The default value is 5439.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
         * characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove
         * quotation marks. The default is <code>false</code>.
         * </p>
         * 
         * @param removeQuotes
         *        A value that specifies to remove surrounding quotation marks from strings in the incoming data. All
         *        characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to
         *        remove quotation marks. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeQuotes(Boolean removeQuotes);

        /**
         * <p>
         * A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
         * </p>
         * 
         * @param replaceInvalidChars
         *        A list of characters that you want to replace. Use with <code>ReplaceChars</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceInvalidChars(String replaceInvalidChars);

        /**
         * <p>
         * A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>,
         * substituting the specified characters instead. The default is <code>"?"</code>.
         * </p>
         * 
         * @param replaceChars
         *        A value that specifies to replaces the invalid characters specified in
         *        <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The default is
         *        <code>"?"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceChars(String replaceChars);

        /**
         * <p>
         * The name of the Amazon Redshift cluster you are using.
         * </p>
         * 
         * @param serverName
         *        The name of the Amazon Redshift cluster you are using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The AWS KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this
         * key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the
         * key.
         * </p>
         * 
         * @param serverSideEncryptionKmsKeyId
         *        The AWS KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide
         *        this key ID. The key that you use needs an attached policy that enables IAM user permissions and
         *        allows use of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId);

        /**
         * <p>
         * The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
         * <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It defaults to
         * 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time
         * format string.
         * </p>
         * <p>
         * If your date and time values use formats different from each other, set this parameter to <code>auto</code>.
         * </p>
         * 
         * @param timeFormat
         *        The time format that you want to use. Valid values are <code>auto</code> (case-sensitive),
         *        <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or <code>'epochmillisecs'</code>. It
         *        defaults to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when
         *        you use a time format string. </p>
         *        <p>
         *        If your date and time values use formats different from each other, set this parameter to
         *        <code>auto</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeFormat(String timeFormat);

        /**
         * <p>
         * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter
         * applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space.
         * The default is <code>false</code>.
         * </p>
         * 
         * @param trimBlanks
         *        A value that specifies to remove the trailing white space characters from a VARCHAR string. This
         *        parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove
         *        unneeded white space. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimBlanks(Boolean trimBlanks);

        /**
         * <p>
         * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data
         * fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a
         * size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code>.
         * </p>
         * 
         * @param truncateColumns
         *        A value that specifies to truncate data in columns to the appropriate number of characters, so that
         *        the data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type,
         *        and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncateColumns(Boolean truncateColumns);

        /**
         * <p>
         * An Amazon Redshift user name for a registered user.
         * </p>
         * 
         * @param username
         *        An Amazon Redshift user name for a registered user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The size of the write buffer to use in rows. Valid values range from 1 through 2,048. The default is 1,024.
         * Use this setting to tune performance.
         * </p>
         * 
         * @param writeBufferSize
         *        The size of the write buffer to use in rows. Valid values range from 1 through 2,048. The default is
         *        1,024. Use this setting to tune performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeBufferSize(Integer writeBufferSize);
    }

    static final class BuilderImpl implements Builder {
        private Boolean acceptAnyDate;

        private String afterConnectScript;

        private String bucketFolder;

        private String bucketName;

        private Integer connectionTimeout;

        private String databaseName;

        private String dateFormat;

        private Boolean emptyAsNull;

        private String encryptionMode;

        private Integer fileTransferUploadStreams;

        private Integer loadTimeout;

        private Integer maxFileSize;

        private String password;

        private Integer port;

        private Boolean removeQuotes;

        private String replaceInvalidChars;

        private String replaceChars;

        private String serverName;

        private String serviceAccessRoleArn;

        private String serverSideEncryptionKmsKeyId;

        private String timeFormat;

        private Boolean trimBlanks;

        private Boolean truncateColumns;

        private String username;

        private Integer writeBufferSize;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSettings model) {
            acceptAnyDate(model.acceptAnyDate);
            afterConnectScript(model.afterConnectScript);
            bucketFolder(model.bucketFolder);
            bucketName(model.bucketName);
            connectionTimeout(model.connectionTimeout);
            databaseName(model.databaseName);
            dateFormat(model.dateFormat);
            emptyAsNull(model.emptyAsNull);
            encryptionMode(model.encryptionMode);
            fileTransferUploadStreams(model.fileTransferUploadStreams);
            loadTimeout(model.loadTimeout);
            maxFileSize(model.maxFileSize);
            password(model.password);
            port(model.port);
            removeQuotes(model.removeQuotes);
            replaceInvalidChars(model.replaceInvalidChars);
            replaceChars(model.replaceChars);
            serverName(model.serverName);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            timeFormat(model.timeFormat);
            trimBlanks(model.trimBlanks);
            truncateColumns(model.truncateColumns);
            username(model.username);
            writeBufferSize(model.writeBufferSize);
        }

        public final Boolean getAcceptAnyDate() {
            return acceptAnyDate;
        }

        @Override
        public final Builder acceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
            return this;
        }

        public final void setAcceptAnyDate(Boolean acceptAnyDate) {
            this.acceptAnyDate = acceptAnyDate;
        }

        public final String getAfterConnectScript() {
            return afterConnectScript;
        }

        @Override
        public final Builder afterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
            return this;
        }

        public final void setAfterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
        }

        public final String getBucketFolder() {
            return bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Integer getConnectionTimeout() {
            return connectionTimeout;
        }

        @Override
        public final Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public final void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDateFormat() {
            return dateFormat;
        }

        @Override
        public final Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public final void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public final Boolean getEmptyAsNull() {
            return emptyAsNull;
        }

        @Override
        public final Builder emptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
            return this;
        }

        public final void setEmptyAsNull(Boolean emptyAsNull) {
            this.emptyAsNull = emptyAsNull;
        }

        public final String getEncryptionModeAsString() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final Integer getFileTransferUploadStreams() {
            return fileTransferUploadStreams;
        }

        @Override
        public final Builder fileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
            return this;
        }

        public final void setFileTransferUploadStreams(Integer fileTransferUploadStreams) {
            this.fileTransferUploadStreams = fileTransferUploadStreams;
        }

        public final Integer getLoadTimeout() {
            return loadTimeout;
        }

        @Override
        public final Builder loadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
            return this;
        }

        public final void setLoadTimeout(Integer loadTimeout) {
            this.loadTimeout = loadTimeout;
        }

        public final Integer getMaxFileSize() {
            return maxFileSize;
        }

        @Override
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getRemoveQuotes() {
            return removeQuotes;
        }

        @Override
        public final Builder removeQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
            return this;
        }

        public final void setRemoveQuotes(Boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
        }

        public final String getReplaceInvalidChars() {
            return replaceInvalidChars;
        }

        @Override
        public final Builder replaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
            return this;
        }

        public final void setReplaceInvalidChars(String replaceInvalidChars) {
            this.replaceInvalidChars = replaceInvalidChars;
        }

        public final String getReplaceChars() {
            return replaceChars;
        }

        @Override
        public final Builder replaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
            return this;
        }

        public final void setReplaceChars(String replaceChars) {
            this.replaceChars = replaceChars;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return serverSideEncryptionKmsKeyId;
        }

        @Override
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        public final String getTimeFormat() {
            return timeFormat;
        }

        @Override
        public final Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public final void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }

        public final Boolean getTrimBlanks() {
            return trimBlanks;
        }

        @Override
        public final Builder trimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
            return this;
        }

        public final void setTrimBlanks(Boolean trimBlanks) {
            this.trimBlanks = trimBlanks;
        }

        public final Boolean getTruncateColumns() {
            return truncateColumns;
        }

        @Override
        public final Builder truncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
            return this;
        }

        public final void setTruncateColumns(Boolean truncateColumns) {
            this.truncateColumns = truncateColumns;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Integer getWriteBufferSize() {
            return writeBufferSize;
        }

        @Override
        public final Builder writeBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return this;
        }

        public final void setWriteBufferSize(Integer writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
        }

        @Override
        public RedshiftSettings build() {
            return new RedshiftSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
