/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MongoDbSettings implements SdkPojo, Serializable, ToCopyableBuilder<MongoDbSettings.Builder, MongoDbSettings> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MongoDbSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<String> AUTH_MECHANISM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::authMechanismAsString)).setter(setter(Builder::authMechanism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMechanism").build()).build();

    private static final SdkField<String> NESTING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::nestingLevelAsString)).setter(setter(Builder::nestingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestingLevel").build()).build();

    private static final SdkField<String> EXTRACT_DOC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::extractDocId)).setter(setter(Builder::extractDocId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractDocId").build()).build();

    private static final SdkField<String> DOCS_TO_INVESTIGATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::docsToInvestigate)).setter(setter(Builder::docsToInvestigate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocsToInvestigate").build()).build();

    private static final SdkField<String> AUTH_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::authSource)).setter(setter(Builder::authSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSource").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MongoDbSettings::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, AUTH_TYPE_FIELD, AUTH_MECHANISM_FIELD,
            NESTING_LEVEL_FIELD, EXTRACT_DOC_ID_FIELD, DOCS_TO_INVESTIGATE_FIELD, AUTH_SOURCE_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String authType;

    private final String authMechanism;

    private final String nestingLevel;

    private final String extractDocId;

    private final String docsToInvestigate;

    private final String authSource;

    private final String kmsKeyId;

    private MongoDbSettings(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.authType = builder.authType;
        this.authMechanism = builder.authMechanism;
        this.nestingLevel = builder.nestingLevel;
        this.extractDocId = builder.extractDocId;
        this.docsToInvestigate = builder.docsToInvestigate;
        this.authSource = builder.authSource;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The user name you use to access the MongoDB source endpoint.
     * </p>
     * 
     * @return The user name you use to access the MongoDB source endpoint.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The password for the user account you use to access the MongoDB source endpoint.
     * </p>
     * 
     * @return The password for the user account you use to access the MongoDB source endpoint.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The name of the server on the MongoDB source endpoint.
     * </p>
     * 
     * @return The name of the server on the MongoDB source endpoint.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the MongoDB source endpoint.
     * </p>
     * 
     * @return The port value for the MongoDB source endpoint.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The database name on the MongoDB source endpoint.
     * </p>
     * 
     * @return The database name on the MongoDB source endpoint.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The authentication type you use to access the MongoDB source endpoint.
     * </p>
     * <p>
     * Valid values: NO, PASSWORD
     * </p>
     * <p>
     * When NO is selected, user name and password parameters are not used and can be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type you use to access the MongoDB source endpoint.</p>
     *         <p>
     *         Valid values: NO, PASSWORD
     *         </p>
     *         <p>
     *         When NO is selected, user name and password parameters are not used and can be empty.
     * @see AuthTypeValue
     */
    public AuthTypeValue authType() {
        return AuthTypeValue.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type you use to access the MongoDB source endpoint.
     * </p>
     * <p>
     * Valid values: NO, PASSWORD
     * </p>
     * <p>
     * When NO is selected, user name and password parameters are not used and can be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type you use to access the MongoDB source endpoint.</p>
     *         <p>
     *         Valid values: NO, PASSWORD
     *         </p>
     *         <p>
     *         When NO is selected, user name and password parameters are not used and can be empty.
     * @see AuthTypeValue
     */
    public String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The authentication mechanism you use to access the MongoDB source endpoint.
     * </p>
     * <p>
     * Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
     * </p>
     * <p>
     * DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting is not
     * used when authType=No.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMechanism}
     * will return {@link AuthMechanismValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authMechanismAsString}.
     * </p>
     * 
     * @return The authentication mechanism you use to access the MongoDB source endpoint.</p>
     *         <p>
     *         Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
     *         </p>
     *         <p>
     *         DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting
     *         is not used when authType=No.
     * @see AuthMechanismValue
     */
    public AuthMechanismValue authMechanism() {
        return AuthMechanismValue.fromValue(authMechanism);
    }

    /**
     * <p>
     * The authentication mechanism you use to access the MongoDB source endpoint.
     * </p>
     * <p>
     * Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
     * </p>
     * <p>
     * DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting is not
     * used when authType=No.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMechanism}
     * will return {@link AuthMechanismValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authMechanismAsString}.
     * </p>
     * 
     * @return The authentication mechanism you use to access the MongoDB source endpoint.</p>
     *         <p>
     *         Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
     *         </p>
     *         <p>
     *         DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting
     *         is not used when authType=No.
     * @see AuthMechanismValue
     */
    public String authMechanismAsString() {
        return authMechanism;
    }

    /**
     * <p>
     * Specifies either document or table mode.
     * </p>
     * <p>
     * Valid values: NONE, ONE
     * </p>
     * <p>
     * Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nestingLevel} will
     * return {@link NestingLevelValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nestingLevelAsString}.
     * </p>
     * 
     * @return Specifies either document or table mode. </p>
     *         <p>
     *         Valid values: NONE, ONE
     *         </p>
     *         <p>
     *         Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
     * @see NestingLevelValue
     */
    public NestingLevelValue nestingLevel() {
        return NestingLevelValue.fromValue(nestingLevel);
    }

    /**
     * <p>
     * Specifies either document or table mode.
     * </p>
     * <p>
     * Valid values: NONE, ONE
     * </p>
     * <p>
     * Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nestingLevel} will
     * return {@link NestingLevelValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nestingLevelAsString}.
     * </p>
     * 
     * @return Specifies either document or table mode. </p>
     *         <p>
     *         Valid values: NONE, ONE
     *         </p>
     *         <p>
     *         Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
     * @see NestingLevelValue
     */
    public String nestingLevelAsString() {
        return nestingLevel;
    }

    /**
     * <p>
     * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to NONE.
     * </p>
     * <p>
     * Default value is false.
     * </p>
     * 
     * @return Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to NONE. </p>
     *         <p>
     *         Default value is false.
     */
    public String extractDocId() {
        return extractDocId;
    }

    /**
     * <p>
     * Indicates the number of documents to preview to determine the document organization. Use this setting when
     * <code>NestingLevel</code> is set to ONE.
     * </p>
     * <p>
     * Must be a positive value greater than 0. Default value is 1000.
     * </p>
     * 
     * @return Indicates the number of documents to preview to determine the document organization. Use this setting
     *         when <code>NestingLevel</code> is set to ONE. </p>
     *         <p>
     *         Must be a positive value greater than 0. Default value is 1000.
     */
    public String docsToInvestigate() {
        return docsToInvestigate;
    }

    /**
     * <p>
     * The MongoDB database name. This setting is not used when <code>authType=NO</code>.
     * </p>
     * <p>
     * The default is admin.
     * </p>
     * 
     * @return The MongoDB database name. This setting is not used when <code>authType=NO</code>. </p>
     *         <p>
     *         The default is admin.
     */
    public String authSource() {
        return authSource;
    }

    /**
     * <p>
     * The AWS KMS key identifier that is used to encrypt the content on the replication instance. If you don't specify
     * a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key. AWS KMS creates
     * the default encryption key for your AWS account. Your AWS account has a different default encryption key for each
     * AWS Region.
     * </p>
     * 
     * @return The AWS KMS key identifier that is used to encrypt the content on the replication instance. If you don't
     *         specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key.
     *         AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default
     *         encryption key for each AWS Region.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nestingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extractDocId());
        hashCode = 31 * hashCode + Objects.hashCode(docsToInvestigate());
        hashCode = 31 * hashCode + Objects.hashCode(authSource());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbSettings)) {
            return false;
        }
        MongoDbSettings other = (MongoDbSettings) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(authMechanismAsString(), other.authMechanismAsString())
                && Objects.equals(nestingLevelAsString(), other.nestingLevelAsString())
                && Objects.equals(extractDocId(), other.extractDocId())
                && Objects.equals(docsToInvestigate(), other.docsToInvestigate())
                && Objects.equals(authSource(), other.authSource()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MongoDbSettings").add("Username", username())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("ServerName", serverName())
                .add("Port", port()).add("DatabaseName", databaseName()).add("AuthType", authTypeAsString())
                .add("AuthMechanism", authMechanismAsString()).add("NestingLevel", nestingLevelAsString())
                .add("ExtractDocId", extractDocId()).add("DocsToInvestigate", docsToInvestigate())
                .add("AuthSource", authSource()).add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "AuthMechanism":
            return Optional.ofNullable(clazz.cast(authMechanismAsString()));
        case "NestingLevel":
            return Optional.ofNullable(clazz.cast(nestingLevelAsString()));
        case "ExtractDocId":
            return Optional.ofNullable(clazz.cast(extractDocId()));
        case "DocsToInvestigate":
            return Optional.ofNullable(clazz.cast(docsToInvestigate()));
        case "AuthSource":
            return Optional.ofNullable(clazz.cast(authSource()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MongoDbSettings, T> g) {
        return obj -> g.apply((MongoDbSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MongoDbSettings> {
        /**
         * <p>
         * The user name you use to access the MongoDB source endpoint.
         * </p>
         * 
         * @param username
         *        The user name you use to access the MongoDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password for the user account you use to access the MongoDB source endpoint.
         * </p>
         * 
         * @param password
         *        The password for the user account you use to access the MongoDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The name of the server on the MongoDB source endpoint.
         * </p>
         * 
         * @param serverName
         *        The name of the server on the MongoDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the MongoDB source endpoint.
         * </p>
         * 
         * @param port
         *        The port value for the MongoDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database name on the MongoDB source endpoint.
         * </p>
         * 
         * @param databaseName
         *        The database name on the MongoDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The authentication type you use to access the MongoDB source endpoint.
         * </p>
         * <p>
         * Valid values: NO, PASSWORD
         * </p>
         * <p>
         * When NO is selected, user name and password parameters are not used and can be empty.
         * </p>
         * 
         * @param authType
         *        The authentication type you use to access the MongoDB source endpoint.</p>
         *        <p>
         *        Valid values: NO, PASSWORD
         *        </p>
         *        <p>
         *        When NO is selected, user name and password parameters are not used and can be empty.
         * @see AuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTypeValue
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type you use to access the MongoDB source endpoint.
         * </p>
         * <p>
         * Valid values: NO, PASSWORD
         * </p>
         * <p>
         * When NO is selected, user name and password parameters are not used and can be empty.
         * </p>
         * 
         * @param authType
         *        The authentication type you use to access the MongoDB source endpoint.</p>
         *        <p>
         *        Valid values: NO, PASSWORD
         *        </p>
         *        <p>
         *        When NO is selected, user name and password parameters are not used and can be empty.
         * @see AuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTypeValue
         */
        Builder authType(AuthTypeValue authType);

        /**
         * <p>
         * The authentication mechanism you use to access the MongoDB source endpoint.
         * </p>
         * <p>
         * Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
         * </p>
         * <p>
         * DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting is
         * not used when authType=No.
         * </p>
         * 
         * @param authMechanism
         *        The authentication mechanism you use to access the MongoDB source endpoint.</p>
         *        <p>
         *        Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
         *        </p>
         *        <p>
         *        DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This
         *        setting is not used when authType=No.
         * @see AuthMechanismValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMechanismValue
         */
        Builder authMechanism(String authMechanism);

        /**
         * <p>
         * The authentication mechanism you use to access the MongoDB source endpoint.
         * </p>
         * <p>
         * Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
         * </p>
         * <p>
         * DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This setting is
         * not used when authType=No.
         * </p>
         * 
         * @param authMechanism
         *        The authentication mechanism you use to access the MongoDB source endpoint.</p>
         *        <p>
         *        Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
         *        </p>
         *        <p>
         *        DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version 3.x, use SCRAM_SHA_1. This
         *        setting is not used when authType=No.
         * @see AuthMechanismValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMechanismValue
         */
        Builder authMechanism(AuthMechanismValue authMechanism);

        /**
         * <p>
         * Specifies either document or table mode.
         * </p>
         * <p>
         * Valid values: NONE, ONE
         * </p>
         * <p>
         * Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
         * </p>
         * 
         * @param nestingLevel
         *        Specifies either document or table mode. </p>
         *        <p>
         *        Valid values: NONE, ONE
         *        </p>
         *        <p>
         *        Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
         * @see NestingLevelValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestingLevelValue
         */
        Builder nestingLevel(String nestingLevel);

        /**
         * <p>
         * Specifies either document or table mode.
         * </p>
         * <p>
         * Valid values: NONE, ONE
         * </p>
         * <p>
         * Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
         * </p>
         * 
         * @param nestingLevel
         *        Specifies either document or table mode. </p>
         *        <p>
         *        Valid values: NONE, ONE
         *        </p>
         *        <p>
         *        Default value is NONE. Specify NONE to use document mode. Specify ONE to use table mode.
         * @see NestingLevelValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestingLevelValue
         */
        Builder nestingLevel(NestingLevelValue nestingLevel);

        /**
         * <p>
         * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to NONE.
         * </p>
         * <p>
         * Default value is false.
         * </p>
         * 
         * @param extractDocId
         *        Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to NONE. </p>
         *        <p>
         *        Default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractDocId(String extractDocId);

        /**
         * <p>
         * Indicates the number of documents to preview to determine the document organization. Use this setting when
         * <code>NestingLevel</code> is set to ONE.
         * </p>
         * <p>
         * Must be a positive value greater than 0. Default value is 1000.
         * </p>
         * 
         * @param docsToInvestigate
         *        Indicates the number of documents to preview to determine the document organization. Use this setting
         *        when <code>NestingLevel</code> is set to ONE. </p>
         *        <p>
         *        Must be a positive value greater than 0. Default value is 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docsToInvestigate(String docsToInvestigate);

        /**
         * <p>
         * The MongoDB database name. This setting is not used when <code>authType=NO</code>.
         * </p>
         * <p>
         * The default is admin.
         * </p>
         * 
         * @param authSource
         *        The MongoDB database name. This setting is not used when <code>authType=NO</code>. </p>
         *        <p>
         *        The default is admin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authSource(String authSource);

        /**
         * <p>
         * The AWS KMS key identifier that is used to encrypt the content on the replication instance. If you don't
         * specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key. AWS
         * KMS creates the default encryption key for your AWS account. Your AWS account has a different default
         * encryption key for each AWS Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS KMS key identifier that is used to encrypt the content on the replication instance. If you
         *        don't specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default
         *        encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has
         *        a different default encryption key for each AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private String serverName;

        private Integer port;

        private String databaseName;

        private String authType;

        private String authMechanism;

        private String nestingLevel;

        private String extractDocId;

        private String docsToInvestigate;

        private String authSource;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbSettings model) {
            username(model.username);
            password(model.password);
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            authType(model.authType);
            authMechanism(model.authMechanism);
            nestingLevel(model.nestingLevel);
            extractDocId(model.extractDocId);
            docsToInvestigate(model.docsToInvestigate);
            authSource(model.authSource);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getAuthTypeAsString() {
            return authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthTypeValue authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        public final String getAuthMechanismAsString() {
            return authMechanism;
        }

        @Override
        public final Builder authMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
            return this;
        }

        @Override
        public final Builder authMechanism(AuthMechanismValue authMechanism) {
            this.authMechanism(authMechanism == null ? null : authMechanism.toString());
            return this;
        }

        public final void setAuthMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
        }

        public final String getNestingLevelAsString() {
            return nestingLevel;
        }

        @Override
        public final Builder nestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
            return this;
        }

        @Override
        public final Builder nestingLevel(NestingLevelValue nestingLevel) {
            this.nestingLevel(nestingLevel == null ? null : nestingLevel.toString());
            return this;
        }

        public final void setNestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
        }

        public final String getExtractDocId() {
            return extractDocId;
        }

        @Override
        public final Builder extractDocId(String extractDocId) {
            this.extractDocId = extractDocId;
            return this;
        }

        public final void setExtractDocId(String extractDocId) {
            this.extractDocId = extractDocId;
        }

        public final String getDocsToInvestigate() {
            return docsToInvestigate;
        }

        @Override
        public final Builder docsToInvestigate(String docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
            return this;
        }

        public final void setDocsToInvestigate(String docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
        }

        public final String getAuthSource() {
            return authSource;
        }

        @Override
        public final Builder authSource(String authSource) {
            this.authSource = authSource;
            return this;
        }

        public final void setAuthSource(String authSource) {
            this.authSource = authSource;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public MongoDbSettings build() {
            return new MongoDbSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
