/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationTaskRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyReplicationTaskRequest.Builder, ModifyReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::replicationTaskArn)).setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::replicationTaskIdentifier))
            .setter(setter(Builder::replicationTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build())
            .build();

    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::migrationTypeAsString)).setter(setter(Builder::migrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::tableMappings)).setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::replicationTaskSettings))
            .setter(setter(Builder::replicationTaskSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build())
            .build();

    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ModifyReplicationTaskRequest::cdcStartTime)).setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()).build();

    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::cdcStartPosition)).setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationTaskRequest::cdcStopPosition)).setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD,
            REPLICATION_TASK_IDENTIFIER_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD,
            CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));

    private final String replicationTaskArn;

    private final String replicationTaskIdentifier;

    private final String migrationType;

    private final String tableMappings;

    private final String replicationTaskSettings;

    private final Instant cdcStartTime;

    private final String cdcStartPosition;

    private final String cdcStopPosition;

    private ModifyReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * The replication task identifier.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The replication task identifier.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String replicationTaskIdentifier() {
        return replicationTaskIdentifier;
    }

    /**
     * <p>
     * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
     *         <code>full-load-and-cdc</code>
     * @see MigrationTypeValue
     */
    public MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(migrationType);
    }

    /**
     * <p>
     * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
     *         <code>full-load-and-cdc</code>
     * @see MigrationTypeValue
     */
    public String migrationTypeAsString() {
        return migrationType;
    }

    /**
     * <p>
     * When using the AWS CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the
     * path with <code>file://</code>. When working with the DMS API, provide the JSON as the parameter value, for
     * example: <code>--table-mappings file://mappingfile.json</code>
     * </p>
     * 
     * @return When using the AWS CLI or boto3, provide the path of the JSON file that contains the table mappings.
     *         Precede the path with <code>file://</code>. When working with the DMS API, provide the JSON as the
     *         parameter value, for example: <code>--table-mappings file://mappingfile.json</code>
     */
    public String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * JSON file that contains settings for the task, such as target metadata settings.
     * </p>
     * 
     * @return JSON file that contains settings for the task, such as target metadata settings.
     */
    public String replicationTaskSettings() {
        return replicationTaskSettings;
    }

    /**
     * <p>
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition
     * to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     * </p>
     * 
     * @return Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
     *         CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public Instant cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * The value can be in date, checkpoint, or LSN/SCN format.
     * </p>
     * <p>
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     * </p>
     * <p>
     * Checkpoint Example: --cdc-start-position
     * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     * </p>
     * <p>
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     * </p>
     * <note>
     * <p>
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be
     * created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra
     * connection attribute to the name of this logical replication slot. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     * >Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a>.
     * </p>
     * </note>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     *         CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         The value can be in date, checkpoint, or LSN/SCN format.
     *         </p>
     *         <p>
     *         Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *         </p>
     *         <p>
     *         Checkpoint Example: --cdc-start-position
     *         "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *         </p>
     *         <p>
     *         LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *         </p>
     *         <note>
     *         <p>
     *         When you use this task setting with a source PostgreSQL database, a logical replication slot should
     *         already be created and associated with the source endpoint. You can verify this by setting the
     *         <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     *         >Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a>.
     *         </p>
     */
    public String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
     * commit time.
     * </p>
     * <p>
     * Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
     * </p>
     * <p>
     * Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
     *         time or commit time.</p>
     *         <p>
     *         Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
     *         </p>
     *         <p>
     *         Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
     */
    public String cdcStopPosition() {
        return cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationTaskRequest)) {
            return false;
        }
        ModifyReplicationTaskRequest other = (ModifyReplicationTaskRequest) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(replicationTaskIdentifier(), other.replicationTaskIdentifier())
                && Objects.equals(migrationTypeAsString(), other.migrationTypeAsString())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationTaskSettings(), other.replicationTaskSettings())
                && Objects.equals(cdcStartTime(), other.cdcStartTime())
                && Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyReplicationTaskRequest").add("ReplicationTaskArn", replicationTaskArn())
                .add("ReplicationTaskIdentifier", replicationTaskIdentifier()).add("MigrationType", migrationTypeAsString())
                .add("TableMappings", tableMappings()).add("ReplicationTaskSettings", replicationTaskSettings())
                .add("CdcStartTime", cdcStartTime()).add("CdcStartPosition", cdcStartPosition())
                .add("CdcStopPosition", cdcStopPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ReplicationTaskIdentifier":
            return Optional.ofNullable(clazz.cast(replicationTaskIdentifier()));
        case "MigrationType":
            return Optional.ofNullable(clazz.cast(migrationTypeAsString()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationTaskSettings":
            return Optional.ofNullable(clazz.cast(replicationTaskSettings()));
        case "CdcStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationTaskRequest, T> g) {
        return obj -> g.apply((ModifyReplicationTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationTaskRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The replication task identifier.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationTaskIdentifier
         *        The replication task identifier.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIdentifier(String replicationTaskIdentifier);

        /**
         * <p>
         * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
         * </p>
         * 
         * @param migrationType
         *        The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
         *        <code>full-load-and-cdc</code>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(String migrationType);

        /**
         * <p>
         * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
         * </p>
         * 
         * @param migrationType
         *        The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
         *        <code>full-load-and-cdc</code>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(MigrationTypeValue migrationType);

        /**
         * <p>
         * When using the AWS CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede
         * the path with <code>file://</code>. When working with the DMS API, provide the JSON as the parameter value,
         * for example: <code>--table-mappings file://mappingfile.json</code>
         * </p>
         * 
         * @param tableMappings
         *        When using the AWS CLI or boto3, provide the path of the JSON file that contains the table mappings.
         *        Precede the path with <code>file://</code>. When working with the DMS API, provide the JSON as the
         *        parameter value, for example: <code>--table-mappings file://mappingfile.json</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * JSON file that contains settings for the task, such as target metadata settings.
         * </p>
         * 
         * @param replicationTaskSettings
         *        JSON file that contains settings for the task, such as target metadata settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskSettings(String replicationTaskSettings);

        /**
         * <p>
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         * CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
         * error.
         * </p>
         * <p>
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * </p>
         * 
         * @param cdcStartTime
         *        Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         *        CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in
         *        an error.</p>
         *        <p>
         *        Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(Instant cdcStartTime);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         * </p>
         * <p>
         * The value can be in date, checkpoint, or LSN/SCN format.
         * </p>
         * <p>
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         * </p>
         * <p>
         * Checkpoint Example: --cdc-start-position
         * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         * </p>
         * <p>
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         * </p>
         * <note>
         * <p>
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already
         * be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code>
         * extra connection attribute to the name of this logical replication slot. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         * >Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a>.
         * </p>
         * </note>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         *        CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
         *        error.</p>
         *        <p>
         *        The value can be in date, checkpoint, or LSN/SCN format.
         *        </p>
         *        <p>
         *        Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *        </p>
         *        <p>
         *        Checkpoint Example: --cdc-start-position
         *        "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *        </p>
         *        <p>
         *        LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *        </p>
         *        <note>
         *        <p>
         *        When you use this task setting with a source PostgreSQL database, a logical replication slot should
         *        already be created and associated with the source endpoint. You can verify this by setting the
         *        <code>slotName</code> extra connection attribute to the name of this logical replication slot. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         *        >Extra Connection Attributes When Using PostgreSQL as a Source for AWS DMS</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
         * commit time.
         * </p>
         * <p>
         * Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
         * </p>
         * <p>
         * Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
         *        time or commit time.</p>
         *        <p>
         *        Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
         *        </p>
         *        <p>
         *        Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12 “
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private String replicationTaskIdentifier;

        private String migrationType;

        private String tableMappings;

        private String replicationTaskSettings;

        private Instant cdcStartTime;

        private String cdcStartPosition;

        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationTaskRequest model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            replicationTaskIdentifier(model.replicationTaskIdentifier);
            migrationType(model.migrationType);
            tableMappings(model.tableMappings);
            replicationTaskSettings(model.replicationTaskSettings);
            cdcStartTime(model.cdcStartTime);
            cdcStartPosition(model.cdcStartPosition);
            cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final String getReplicationTaskIdentifier() {
            return replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getMigrationTypeAsString() {
            return migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        public final String getReplicationTaskSettings() {
            return replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        public final Instant getCdcStartTime() {
            return cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationTaskRequest build() {
            return new ModifyReplicationTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
