/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisSettings implements SdkPojo, Serializable, ToCopyableBuilder<KinesisSettings.Builder, KinesisSettings> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::messageFormatAsString)).setter(setter(Builder::messageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            MESSAGE_FORMAT_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String messageFormat;

    private final String serviceAccessRoleArn;

    private KinesisSettings(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.messageFormat = builder.messageFormat;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>.
     * @see MessageFormatValue
     */
    public MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(messageFormat);
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>.
     * @see MessageFormatValue
     */
    public String messageFormatAsString() {
        return messageFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Amazon Kinesis data stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Amazon Kinesis data stream.
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisSettings)) {
            return false;
        }
        KinesisSettings other = (KinesisSettings) obj;
        return Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(messageFormatAsString(), other.messageFormatAsString())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KinesisSettings").add("StreamArn", streamArn()).add("MessageFormat", messageFormatAsString())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "MessageFormat":
            return Optional.ofNullable(clazz.cast(messageFormatAsString()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisSettings, T> g) {
        return obj -> g.apply((KinesisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisSettings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code>.
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>.
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code>.
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>.
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(MessageFormatValue messageFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Amazon Kinesis data stream.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Amazon Kinesis data
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String messageFormat;

        private String serviceAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisSettings model) {
            streamArn(model.streamArn);
            messageFormat(model.messageFormat);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getMessageFormatAsString() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public KinesisSettings build() {
            return new KinesisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
