/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportCertificateRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ImportCertificateRequest.Builder, ImportCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportCertificateRequest::certificateIdentifier)).setter(setter(Builder::certificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build())
            .build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportCertificateRequest::certificatePem)).setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePem").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATE_WALLET_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImportCertificateRequest::certificateWallet)).setter(setter(Builder::certificateWallet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateWallet").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ImportCertificateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD,
            CERTIFICATE_PEM_FIELD, CERTIFICATE_WALLET_FIELD, TAGS_FIELD));

    private final String certificateIdentifier;

    private final String certificatePem;

    private final SdkBytes certificateWallet;

    private final List<Tag> tags;

    private ImportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificatePem = builder.certificatePem;
        this.certificateWallet = builder.certificateWallet;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A customer-assigned name for the certificate. Identifiers must begin with a letter; must contain only ASCII
     * letters, digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return A customer-assigned name for the certificate. Identifiers must begin with a letter; must contain only
     *         ASCII letters, digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
     */
    public String certificateIdentifier() {
        return certificateIdentifier;
    }

    /**
     * <p>
     * The contents of a <code>.pem</code> file, which contains an X.509 certificate.
     * </p>
     * 
     * @return The contents of a <code>.pem</code> file, which contains an X.509 certificate.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The location of an imported Oracle Wallet certificate for use with SSL.
     * </p>
     * 
     * @return The location of an imported Oracle Wallet certificate for use with SSL.
     */
    public SdkBytes certificateWallet() {
        return certificateWallet;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the certificate.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(certificateWallet());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest) obj;
        return Objects.equals(certificateIdentifier(), other.certificateIdentifier())
                && Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(certificateWallet(), other.certificateWallet()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportCertificateRequest").add("CertificateIdentifier", certificateIdentifier())
                .add("CertificatePem", certificatePem()).add("CertificateWallet", certificateWallet()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateIdentifier":
            return Optional.ofNullable(clazz.cast(certificateIdentifier()));
        case "CertificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "CertificateWallet":
            return Optional.ofNullable(clazz.cast(certificateWallet()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportCertificateRequest> {
        /**
         * <p>
         * A customer-assigned name for the certificate. Identifiers must begin with a letter; must contain only ASCII
         * letters, digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param certificateIdentifier
         *        A customer-assigned name for the certificate. Identifiers must begin with a letter; must contain only
         *        ASCII letters, digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIdentifier(String certificateIdentifier);

        /**
         * <p>
         * The contents of a <code>.pem</code> file, which contains an X.509 certificate.
         * </p>
         * 
         * @param certificatePem
         *        The contents of a <code>.pem</code> file, which contains an X.509 certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The location of an imported Oracle Wallet certificate for use with SSL.
         * </p>
         * 
         * @param certificateWallet
         *        The location of an imported Oracle Wallet certificate for use with SSL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateWallet(SdkBytes certificateWallet);

        /**
         * <p>
         * The tags associated with the certificate.
         * </p>
         * 
         * @param tags
         *        The tags associated with the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the certificate.
         * </p>
         * 
         * @param tags
         *        The tags associated with the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String certificateIdentifier;

        private String certificatePem;

        private SdkBytes certificateWallet;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            super(model);
            certificateIdentifier(model.certificateIdentifier);
            certificatePem(model.certificatePem);
            certificateWallet(model.certificateWallet);
            tags(model.tags);
        }

        public final String getCertificateIdentifier() {
            return certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final ByteBuffer getCertificateWallet() {
            return certificateWallet == null ? null : certificateWallet.asByteBuffer();
        }

        @Override
        public final Builder certificateWallet(SdkBytes certificateWallet) {
            this.certificateWallet = StandardMemberCopier.copy(certificateWallet);
            return this;
        }

        public final void setCertificateWallet(ByteBuffer certificateWallet) {
            certificateWallet(certificateWallet == null ? null : SdkBytes.fromByteBuffer(certificateWallet));
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
