/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableStatisticsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeTableStatisticsResponse.Builder, DescribeTableStatisticsResponse> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTableStatisticsResponse::replicationTaskArn)).setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<List<TableStatistics>> TABLE_STATISTICS_FIELD = SdkField
            .<List<TableStatistics>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTableStatisticsResponse::tableStatistics))
            .setter(setter(Builder::tableStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTableStatisticsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD,
            TABLE_STATISTICS_FIELD, MARKER_FIELD));

    private final String replicationTaskArn;

    private final List<TableStatistics> tableStatistics;

    private final String marker;

    private DescribeTableStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.tableStatistics = builder.tableStatistics;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * Returns true if the TableStatistics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTableStatistics() {
        return tableStatistics != null && !(tableStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The table statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The table statistics.
     */
    public List<TableStatistics> tableStatistics() {
        return tableStatistics;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableStatisticsResponse)) {
            return false;
        }
        DescribeTableStatisticsResponse other = (DescribeTableStatisticsResponse) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(tableStatistics(), other.tableStatistics()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTableStatisticsResponse").add("ReplicationTaskArn", replicationTaskArn())
                .add("TableStatistics", tableStatistics()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "TableStatistics":
            return Optional.ofNullable(clazz.cast(tableStatistics()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeTableStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTableStatisticsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The table statistics.
         * </p>
         * 
         * @param tableStatistics
         *        The table statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableStatistics(Collection<TableStatistics> tableStatistics);

        /**
         * <p>
         * The table statistics.
         * </p>
         * 
         * @param tableStatistics
         *        The table statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableStatistics(TableStatistics... tableStatistics);

        /**
         * <p>
         * The table statistics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableStatistics>.Builder} avoiding the need
         * to create one manually via {@link List<TableStatistics>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableStatistics>.Builder#build()} is called immediately and
         * its result is passed to {@link #tableStatistics(List<TableStatistics>)}.
         * 
         * @param tableStatistics
         *        a consumer that will call methods on {@link List<TableStatistics>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableStatistics(List<TableStatistics>)
         */
        Builder tableStatistics(Consumer<TableStatistics.Builder>... tableStatistics);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private List<TableStatistics> tableStatistics = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableStatisticsResponse model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            tableStatistics(model.tableStatistics);
            marker(model.marker);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final Collection<TableStatistics.Builder> getTableStatistics() {
            return tableStatistics != null ? tableStatistics.stream().map(TableStatistics::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableStatistics(Collection<TableStatistics> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copy(tableStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableStatistics(TableStatistics... tableStatistics) {
            tableStatistics(Arrays.asList(tableStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableStatistics(Consumer<TableStatistics.Builder>... tableStatistics) {
            tableStatistics(Stream.of(tableStatistics).map(c -> TableStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTableStatistics(Collection<TableStatistics.BuilderImpl> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copyFromBuilder(tableStatistics);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTableStatisticsResponse build() {
            return new DescribeTableStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
