/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrderableReplicationInstancesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeOrderableReplicationInstancesResponse.Builder, DescribeOrderableReplicationInstancesResponse> {
    private static final SdkField<List<OrderableReplicationInstance>> ORDERABLE_REPLICATION_INSTANCES_FIELD = SdkField
            .<List<OrderableReplicationInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOrderableReplicationInstancesResponse::orderableReplicationInstances))
            .setter(setter(Builder::orderableReplicationInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableReplicationInstances")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderableReplicationInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderableReplicationInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrderableReplicationInstancesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERABLE_REPLICATION_INSTANCES_FIELD, MARKER_FIELD));

    private final List<OrderableReplicationInstance> orderableReplicationInstances;

    private final String marker;

    private DescribeOrderableReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.orderableReplicationInstances = builder.orderableReplicationInstances;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the OrderableReplicationInstances property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasOrderableReplicationInstances() {
        return orderableReplicationInstances != null && !(orderableReplicationInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order-able replication instances available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderableReplicationInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The order-able replication instances available.
     */
    public List<OrderableReplicationInstance> orderableReplicationInstances() {
        return orderableReplicationInstances;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(orderableReplicationInstances());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableReplicationInstancesResponse)) {
            return false;
        }
        DescribeOrderableReplicationInstancesResponse other = (DescribeOrderableReplicationInstancesResponse) obj;
        return Objects.equals(orderableReplicationInstances(), other.orderableReplicationInstances())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrderableReplicationInstancesResponse")
                .add("OrderableReplicationInstances", orderableReplicationInstances()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderableReplicationInstances":
            return Optional.ofNullable(clazz.cast(orderableReplicationInstances()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableReplicationInstancesResponse, T> g) {
        return obj -> g.apply((DescribeOrderableReplicationInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrderableReplicationInstancesResponse> {
        /**
         * <p>
         * The order-able replication instances available.
         * </p>
         * 
         * @param orderableReplicationInstances
         *        The order-able replication instances available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> orderableReplicationInstances);

        /**
         * <p>
         * The order-able replication instances available.
         * </p>
         * 
         * @param orderableReplicationInstances
         *        The order-able replication instances available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableReplicationInstances(OrderableReplicationInstance... orderableReplicationInstances);

        /**
         * <p>
         * The order-able replication instances available.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrderableReplicationInstance>.Builder}
         * avoiding the need to create one manually via {@link List<OrderableReplicationInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrderableReplicationInstance>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #orderableReplicationInstances(List<OrderableReplicationInstance>)}.
         * 
         * @param orderableReplicationInstances
         *        a consumer that will call methods on {@link List<OrderableReplicationInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderableReplicationInstances(List<OrderableReplicationInstance>)
         */
        Builder orderableReplicationInstances(Consumer<OrderableReplicationInstance.Builder>... orderableReplicationInstances);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<OrderableReplicationInstance> orderableReplicationInstances = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableReplicationInstancesResponse model) {
            super(model);
            orderableReplicationInstances(model.orderableReplicationInstances);
            marker(model.marker);
        }

        public final Collection<OrderableReplicationInstance.Builder> getOrderableReplicationInstances() {
            return orderableReplicationInstances != null ? orderableReplicationInstances.stream()
                    .map(OrderableReplicationInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier.copy(orderableReplicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableReplicationInstances(OrderableReplicationInstance... orderableReplicationInstances) {
            orderableReplicationInstances(Arrays.asList(orderableReplicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableReplicationInstances(
                Consumer<OrderableReplicationInstance.Builder>... orderableReplicationInstances) {
            orderableReplicationInstances(Stream.of(orderableReplicationInstances)
                    .map(c -> OrderableReplicationInstance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableReplicationInstances(
                Collection<OrderableReplicationInstance.BuilderImpl> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier
                    .copyFromBuilder(orderableReplicationInstances);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableReplicationInstancesResponse build() {
            return new DescribeOrderableReplicationInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
