/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connection implements SdkPojo, Serializable, ToCopyableBuilder<Connection.Builder, Connection> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::replicationInstanceArn)).setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::lastFailureMessage)).setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::endpointIdentifier)).setter(setter(Builder::endpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Connection::replicationInstanceIdentifier))
            .setter(setter(Builder::replicationInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_ARN_FIELD, ENDPOINT_ARN_FIELD, STATUS_FIELD, LAST_FAILURE_MESSAGE_FIELD,
            ENDPOINT_IDENTIFIER_FIELD, REPLICATION_INSTANCE_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationInstanceArn;

    private final String endpointArn;

    private final String status;

    private final String lastFailureMessage;

    private final String endpointIdentifier;

    private final String replicationInstanceIdentifier;

    private Connection(BuilderImpl builder) {
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The connection status.
     * </p>
     * 
     * @return The connection status.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The error message when the connection last failed.
     * </p>
     * 
     * @return The error message when the connection last failed.
     */
    public String lastFailureMessage() {
        return lastFailureMessage;
    }

    /**
     * <p>
     * The identifier of the endpoint. Identifiers must begin with a letter; must contain only ASCII letters, digits,
     * and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The identifier of the endpoint. Identifiers must begin with a letter; must contain only ASCII letters,
     *         digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
     */
    public String endpointIdentifier() {
        return endpointIdentifier;
    }

    /**
     * <p>
     * The replication instance identifier. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The replication instance identifier. This parameter is stored as a lowercase string.
     */
    public String replicationInstanceIdentifier() {
        return replicationInstanceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection) obj;
        return Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage())
                && Objects.equals(endpointIdentifier(), other.endpointIdentifier())
                && Objects.equals(replicationInstanceIdentifier(), other.replicationInstanceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Connection").add("ReplicationInstanceArn", replicationInstanceArn())
                .add("EndpointArn", endpointArn()).add("Status", status()).add("LastFailureMessage", lastFailureMessage())
                .add("EndpointIdentifier", endpointIdentifier())
                .add("ReplicationInstanceIdentifier", replicationInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        case "EndpointIdentifier":
            return Optional.ofNullable(clazz.cast(endpointIdentifier()));
        case "ReplicationInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationInstanceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connection> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The connection status.
         * </p>
         * 
         * @param status
         *        The connection status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The error message when the connection last failed.
         * </p>
         * 
         * @param lastFailureMessage
         *        The error message when the connection last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);

        /**
         * <p>
         * The identifier of the endpoint. Identifiers must begin with a letter; must contain only ASCII letters,
         * digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param endpointIdentifier
         *        The identifier of the endpoint. Identifiers must begin with a letter; must contain only ASCII letters,
         *        digits, and hyphens; and must not end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIdentifier(String endpointIdentifier);

        /**
         * <p>
         * The replication instance identifier. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param replicationInstanceIdentifier
         *        The replication instance identifier. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIdentifier(String replicationInstanceIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String replicationInstanceArn;

        private String endpointArn;

        private String status;

        private String lastFailureMessage;

        private String endpointIdentifier;

        private String replicationInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            replicationInstanceArn(model.replicationInstanceArn);
            endpointArn(model.endpointArn);
            status(model.status);
            lastFailureMessage(model.lastFailureMessage);
            endpointIdentifier(model.endpointIdentifier);
            replicationInstanceIdentifier(model.replicationInstanceIdentifier);
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public final String getEndpointIdentifier() {
            return endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getReplicationInstanceIdentifier() {
            return replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
