/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;

public class DescribeEndpointsIterable
implements SdkIterable<DescribeEndpointsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointsIterable(DatabaseMigrationClient client, DescribeEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEndpointsResponseFetcher();
    }

    public Iterator<DescribeEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeEndpointsIterable resume(DescribeEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEndpointsIterable(this.client, (DescribeEndpointsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeEndpointsResponse> {
        private DescribeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointsResponse nextPage(DescribeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointsIterable.this.client.describeEndpoints(DescribeEndpointsIterable.this.firstRequest);
            }
            return DescribeEndpointsIterable.this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

