/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SupportedEndpointTypeMarshaller {
    private static final MarshallingInfo<String> ENGINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SUPPORTSCDC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportsCDC").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEDISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineDisplayName").isBinary(false).build();
    private static final SupportedEndpointTypeMarshaller INSTANCE = new SupportedEndpointTypeMarshaller();

    private SupportedEndpointTypeMarshaller() {
    }

    public static SupportedEndpointTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SupportedEndpointType supportedEndpointType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)supportedEndpointType, (String)"supportedEndpointType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)supportedEndpointType.engineName(), ENGINENAME_BINDING);
            protocolMarshaller.marshall((Object)supportedEndpointType.supportsCDC(), SUPPORTSCDC_BINDING);
            protocolMarshaller.marshall((Object)supportedEndpointType.endpointTypeAsString(), ENDPOINTTYPE_BINDING);
            protocolMarshaller.marshall((Object)supportedEndpointType.engineDisplayName(), ENGINEDISPLAYNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

