/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.S3Settings;

public class S3SettingsUnmarshaller
implements Unmarshaller<S3Settings, JsonUnmarshallerContext> {
    private static final S3SettingsUnmarshaller INSTANCE = new S3SettingsUnmarshaller();

    public S3Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Settings.Builder s3SettingsBuilder = S3Settings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ServiceAccessRoleArn", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.serviceAccessRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExternalTableDefinition", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.externalTableDefinition((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CsvRowDelimiter", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.csvRowDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CsvDelimiter", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.csvDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BucketFolder", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.bucketFolder((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BucketName", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.bucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CompressionType", targetDepth)) {
                    context.nextToken();
                    s3SettingsBuilder.compressionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Settings)s3SettingsBuilder.build();
    }

    public static S3SettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

