/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationTaskStatsMarshaller {
    private static final MarshallingInfo<Integer> FULLLOADPROGRESSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadProgressPercent").isBinary(false).build();
    private static final MarshallingInfo<Long> ELAPSEDTIMEMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElapsedTimeMillis").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESLOADED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesLoaded").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESLOADING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesLoading").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESQUEUED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesQueued").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESERRORED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesErrored").isBinary(false).build();
    private static final ReplicationTaskStatsMarshaller INSTANCE = new ReplicationTaskStatsMarshaller();

    private ReplicationTaskStatsMarshaller() {
    }

    public static ReplicationTaskStatsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationTaskStats replicationTaskStats, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationTaskStats, (String)"replicationTaskStats");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationTaskStats.fullLoadProgressPercent(), FULLLOADPROGRESSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskStats.elapsedTimeMillis(), ELAPSEDTIMEMILLIS_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskStats.tablesLoaded(), TABLESLOADED_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskStats.tablesLoading(), TABLESLOADING_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskStats.tablesQueued(), TABLESQUEUED_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskStats.tablesErrored(), TABLESERRORED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

