/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTask;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationTaskMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceEndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetEndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> MIGRATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MigrationType").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableMappings").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskSettings").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> LASTFAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastFailureMessage").isBinary(false).build();
    private static final MarshallingInfo<String> STOPREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StopReason").isBinary(false).build();
    private static final MarshallingInfo<Instant> REPLICATIONTASKCREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskCreationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> REPLICATIONTASKSTARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskStartDate").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTARTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStartPosition").isBinary(false).build();
    private static final MarshallingInfo<String> CDCSTOPPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdcStopPosition").isBinary(false).build();
    private static final MarshallingInfo<String> RECOVERYCHECKPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecoveryCheckpoint").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REPLICATIONTASKSTATS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskStats").isBinary(false).build();
    private static final ReplicationTaskMarshaller INSTANCE = new ReplicationTaskMarshaller();

    private ReplicationTaskMarshaller() {
    }

    public static ReplicationTaskMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationTask replicationTask, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationTask, (String)"replicationTask");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskIdentifier(), REPLICATIONTASKIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.sourceEndpointArn(), SOURCEENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.targetEndpointArn(), TARGETENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationInstanceArn(), REPLICATIONINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.migrationTypeAsString(), MIGRATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.tableMappings(), TABLEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskSettings(), REPLICATIONTASKSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.lastFailureMessage(), LASTFAILUREMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.stopReason(), STOPREASON_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskCreationDate(), REPLICATIONTASKCREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskStartDate(), REPLICATIONTASKSTARTDATE_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.cdcStartPosition(), CDCSTARTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.cdcStopPosition(), CDCSTOPPOSITION_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.recoveryCheckpoint(), RECOVERYCHECKPOINT_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall((Object)replicationTask.replicationTaskStats(), REPLICATIONTASKSTATS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

