/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationTaskAssessmentResultMarshaller {
    private static final MarshallingInfo<String> REPLICATIONTASKIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONTASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> REPLICATIONTASKLASTASSESSMENTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationTaskLastAssessmentDate").isBinary(false).build();
    private static final MarshallingInfo<String> ASSESSMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssessmentStatus").isBinary(false).build();
    private static final MarshallingInfo<String> ASSESSMENTRESULTSFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssessmentResultsFile").isBinary(false).build();
    private static final MarshallingInfo<String> ASSESSMENTRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssessmentResults").isBinary(false).build();
    private static final MarshallingInfo<String> S3OBJECTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ObjectUrl").isBinary(false).build();
    private static final ReplicationTaskAssessmentResultMarshaller INSTANCE = new ReplicationTaskAssessmentResultMarshaller();

    private ReplicationTaskAssessmentResultMarshaller() {
    }

    public static ReplicationTaskAssessmentResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationTaskAssessmentResult replicationTaskAssessmentResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationTaskAssessmentResult, (String)"replicationTaskAssessmentResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.replicationTaskIdentifier(), REPLICATIONTASKIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.replicationTaskArn(), REPLICATIONTASKARN_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.replicationTaskLastAssessmentDate(), REPLICATIONTASKLASTASSESSMENTDATE_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.assessmentStatus(), ASSESSMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.assessmentResultsFile(), ASSESSMENTRESULTSFILE_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.assessmentResults(), ASSESSMENTRESULTS_BINDING);
            protocolMarshaller.marshall((Object)replicationTaskAssessmentResult.s3ObjectUrl(), S3OBJECTURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

