/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrderableReplicationInstanceMarshaller {
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONINSTANCECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationInstanceClass").isBinary(false).build();
    private static final MarshallingInfo<String> STORAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageType").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinAllocatedStorage").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAllocatedStorage").isBinary(false).build();
    private static final MarshallingInfo<Integer> DEFAULTALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAllocatedStorage").isBinary(false).build();
    private static final MarshallingInfo<Integer> INCLUDEDALLOCATEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludedAllocatedStorage").isBinary(false).build();
    private static final OrderableReplicationInstanceMarshaller INSTANCE = new OrderableReplicationInstanceMarshaller();

    private OrderableReplicationInstanceMarshaller() {
    }

    public static OrderableReplicationInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OrderableReplicationInstance orderableReplicationInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)orderableReplicationInstance, (String)"orderableReplicationInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)orderableReplicationInstance.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.replicationInstanceClass(), REPLICATIONINSTANCECLASS_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.storageType(), STORAGETYPE_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.minAllocatedStorage(), MINALLOCATEDSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.maxAllocatedStorage(), MAXALLOCATEDSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.defaultAllocatedStorage(), DEFAULTALLOCATEDSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)orderableReplicationInstance.includedAllocatedStorage(), INCLUDEDALLOCATEDSTORAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

