/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.MongoDbSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MongoDbSettingsMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHMECHANISM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthMechanism").isBinary(false).build();
    private static final MarshallingInfo<String> NESTINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NestingLevel").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRACTDOCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtractDocId").isBinary(false).build();
    private static final MarshallingInfo<String> DOCSTOINVESTIGATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocsToInvestigate").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthSource").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MongoDbSettingsMarshaller INSTANCE = new MongoDbSettingsMarshaller();

    private MongoDbSettingsMarshaller() {
    }

    public static MongoDbSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MongoDbSettings mongoDbSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mongoDbSettings, (String)"mongoDbSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mongoDbSettings.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.authTypeAsString(), AUTHTYPE_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.authMechanismAsString(), AUTHMECHANISM_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.nestingLevelAsString(), NESTINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.extractDocId(), EXTRACTDOCID_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.docsToInvestigate(), DOCSTOINVESTIGATE_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.authSource(), AUTHSOURCE_BINDING);
            protocolMarshaller.marshall((Object)mongoDbSettings.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

