/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyEventSubscriptionRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionName").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTCATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCategories").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final ModifyEventSubscriptionRequestModelMarshaller INSTANCE = new ModifyEventSubscriptionRequestModelMarshaller();

    private ModifyEventSubscriptionRequestModelMarshaller() {
    }

    public static ModifyEventSubscriptionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyEventSubscriptionRequest), (String)"modifyEventSubscriptionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyEventSubscriptionRequest.subscriptionName(), SUBSCRIPTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)modifyEventSubscriptionRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)modifyEventSubscriptionRequest.sourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall(modifyEventSubscriptionRequest.eventCategories(), EVENTCATEGORIES_BINDING);
            protocolMarshaller.marshall((Object)modifyEventSubscriptionRequest.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

