/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificatePem").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> CERTIFICATEWALLET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateWallet").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final ImportCertificateRequestModelMarshaller INSTANCE = new ImportCertificateRequestModelMarshaller();

    private ImportCertificateRequestModelMarshaller() {
    }

    public static ImportCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportCertificateRequest importCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importCertificateRequest), (String)"importCertificateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateIdentifier(), CERTIFICATEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateWallet(), CERTIFICATEWALLET_BINDING);
            protocolMarshaller.marshall(importCertificateRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

