/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.EventSubscription;

public class EventSubscriptionUnmarshaller
implements Unmarshaller<EventSubscription, JsonUnmarshallerContext> {
    private static final EventSubscriptionUnmarshaller INSTANCE = new EventSubscriptionUnmarshaller();

    public EventSubscription unmarshall(JsonUnmarshallerContext context) throws Exception {
        EventSubscription.Builder eventSubscriptionBuilder = EventSubscription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CustomerAwsId", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.customerAwsId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustSubscriptionId", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.custSubscriptionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SnsTopicArn", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.snsTopicArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubscriptionCreationTime", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.subscriptionCreationTime((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.sourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceIdsList", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.sourceIdsList(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("EventCategoriesList", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.eventCategoriesList(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    eventSubscriptionBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EventSubscription)eventSubscriptionBuilder.build();
    }

    public static EventSubscriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

