/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.EventSubscription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventSubscriptionMarshaller {
    private static final MarshallingInfo<String> CUSTOMERAWSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomerAwsId").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTSUBSCRIPTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustSubscriptionId").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> SUBSCRIPTIONCREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionCreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<List> SOURCEIDSLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIdsList").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTCATEGORIESLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCategoriesList").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final EventSubscriptionMarshaller INSTANCE = new EventSubscriptionMarshaller();

    private EventSubscriptionMarshaller() {
    }

    public static EventSubscriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventSubscription eventSubscription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventSubscription, (String)"eventSubscription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventSubscription.customerAwsId(), CUSTOMERAWSID_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.custSubscriptionId(), CUSTSUBSCRIPTIONID_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.subscriptionCreationTime(), SUBSCRIPTIONCREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.sourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall(eventSubscription.sourceIdsList(), SOURCEIDSLIST_BINDING);
            protocolMarshaller.marshall(eventSubscription.eventCategoriesList(), EVENTCATEGORIESLIST_BINDING);
            protocolMarshaller.marshall((Object)eventSubscription.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

