/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.databasemigration.model.Endpoint;
import software.amazon.awssdk.services.databasemigration.transform.DmsTransferSettingsUnmarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DynamoDbSettingsUnmarshaller;
import software.amazon.awssdk.services.databasemigration.transform.MongoDbSettingsUnmarshaller;
import software.amazon.awssdk.services.databasemigration.transform.S3SettingsUnmarshaller;

public class EndpointUnmarshaller
implements Unmarshaller<Endpoint, JsonUnmarshallerContext> {
    private static final EndpointUnmarshaller INSTANCE = new EndpointUnmarshaller();

    public Endpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        Endpoint.Builder endpointBuilder = Endpoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("EndpointIdentifier", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.endpointIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointType", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.endpointType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EngineName", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.engineName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EngineDisplayName", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.engineDisplayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Username", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.username((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServerName", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.serverName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Port", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.port((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExtraConnectionAttributes", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.extraConnectionAttributes((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointArn", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.endpointArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CertificateArn", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.certificateArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SslMode", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.sslMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ServiceAccessRoleArn", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.serviceAccessRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExternalTableDefinition", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.externalTableDefinition((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExternalId", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.externalId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DynamoDbSettings", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.dynamoDbSettings(DynamoDbSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3Settings", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.s3Settings(S3SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DmsTransferSettings", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.dmsTransferSettings(DmsTransferSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MongoDbSettings", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.mongoDbSettings(MongoDbSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Endpoint)endpointBuilder.build();
    }

    public static EndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

