/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointMarshaller {
    private static final MarshallingInfo<String> ENDPOINTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineName").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEDISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineDisplayName").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRACONNECTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraConnectionAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> SSLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslMode").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALTABLEDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalTableDefinition").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DynamoDbSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DMSTRANSFERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DmsTransferSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MONGODBSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MongoDbSettings").isBinary(false).build();
    private static final EndpointMarshaller INSTANCE = new EndpointMarshaller();

    private EndpointMarshaller() {
    }

    public static EndpointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Endpoint endpoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpoint, (String)"endpoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpoint.endpointIdentifier(), ENDPOINTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)endpoint.endpointTypeAsString(), ENDPOINTTYPE_BINDING);
            protocolMarshaller.marshall((Object)endpoint.engineName(), ENGINENAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.engineDisplayName(), ENGINEDISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)endpoint.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)endpoint.extraConnectionAttributes(), EXTRACONNECTIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)endpoint.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)endpoint.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)endpoint.endpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.sslModeAsString(), SSLMODE_BINDING);
            protocolMarshaller.marshall((Object)endpoint.serviceAccessRoleArn(), SERVICEACCESSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.externalTableDefinition(), EXTERNALTABLEDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)endpoint.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)endpoint.dynamoDbSettings(), DYNAMODBSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)endpoint.s3Settings(), S3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)endpoint.dmsTransferSettings(), DMSTRANSFERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)endpoint.mongoDbSettings(), MONGODBSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

