/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.Certificate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CertificateMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateIdentifier").isBinary(false).build();
    private static final MarshallingInfo<Instant> CERTIFICATECREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateCreationDate").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificatePem").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> CERTIFICATEWALLET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateWallet").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEOWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateOwner").isBinary(false).build();
    private static final MarshallingInfo<Instant> VALIDFROMDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidFromDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> VALIDTODATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidToDate").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNINGALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<Integer> KEYLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyLength").isBinary(false).build();
    private static final CertificateMarshaller INSTANCE = new CertificateMarshaller();

    private CertificateMarshaller() {
    }

    public static CertificateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Certificate certificate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)certificate, (String)"certificate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)certificate.certificateIdentifier(), CERTIFICATEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)certificate.certificateCreationDate(), CERTIFICATECREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)certificate.certificateWallet(), CERTIFICATEWALLET_BINDING);
            protocolMarshaller.marshall((Object)certificate.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificate.certificateOwner(), CERTIFICATEOWNER_BINDING);
            protocolMarshaller.marshall((Object)certificate.validFromDate(), VALIDFROMDATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.validToDate(), VALIDTODATE_BINDING);
            protocolMarshaller.marshall((Object)certificate.signingAlgorithm(), SIGNINGALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)certificate.keyLength(), KEYLENGTH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

