/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.AccountQuota;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AccountQuotaMarshaller {
    private static final MarshallingInfo<String> ACCOUNTQUOTANAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountQuotaName").isBinary(false).build();
    private static final MarshallingInfo<Long> USED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Used").isBinary(false).build();
    private static final MarshallingInfo<Long> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Max").isBinary(false).build();
    private static final AccountQuotaMarshaller INSTANCE = new AccountQuotaMarshaller();

    private AccountQuotaMarshaller() {
    }

    public static AccountQuotaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountQuota accountQuota, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)accountQuota, (String)"accountQuota");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)accountQuota.accountQuotaName(), ACCOUNTQUOTANAME_BINDING);
            protocolMarshaller.marshall((Object)accountQuota.used(), USED_BINDING);
            protocolMarshaller.marshall((Object)accountQuota.max(), MAX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

