/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.ReplicationTaskStatsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTaskStats
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicationTaskStats> {
    private final Integer fullLoadProgressPercent;
    private final Long elapsedTimeMillis;
    private final Integer tablesLoaded;
    private final Integer tablesLoading;
    private final Integer tablesQueued;
    private final Integer tablesErrored;

    private ReplicationTaskStats(BuilderImpl builder) {
        this.fullLoadProgressPercent = builder.fullLoadProgressPercent;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoaded = builder.tablesLoaded;
        this.tablesLoading = builder.tablesLoading;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
    }

    public Integer fullLoadProgressPercent() {
        return this.fullLoadProgressPercent;
    }

    public Long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public Integer tablesLoaded() {
        return this.tablesLoaded;
    }

    public Integer tablesLoading() {
        return this.tablesLoading;
    }

    public Integer tablesQueued() {
        return this.tablesQueued;
    }

    public Integer tablesErrored() {
        return this.tablesErrored;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadProgressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesErrored());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskStats)) {
            return false;
        }
        ReplicationTaskStats other = (ReplicationTaskStats)obj;
        return Objects.equals(this.fullLoadProgressPercent(), other.fullLoadProgressPercent()) && Objects.equals(this.elapsedTimeMillis(), other.elapsedTimeMillis()) && Objects.equals(this.tablesLoaded(), other.tablesLoaded()) && Objects.equals(this.tablesLoading(), other.tablesLoading()) && Objects.equals(this.tablesQueued(), other.tablesQueued()) && Objects.equals(this.tablesErrored(), other.tablesErrored());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationTaskStats").add("FullLoadProgressPercent", (Object)this.fullLoadProgressPercent()).add("ElapsedTimeMillis", (Object)this.elapsedTimeMillis()).add("TablesLoaded", (Object)this.tablesLoaded()).add("TablesLoading", (Object)this.tablesLoading()).add("TablesQueued", (Object)this.tablesQueued()).add("TablesErrored", (Object)this.tablesErrored()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FullLoadProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.fullLoadProgressPercent()));
            }
            case "ElapsedTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeMillis()));
            }
            case "TablesLoaded": {
                return Optional.ofNullable(clazz.cast(this.tablesLoaded()));
            }
            case "TablesLoading": {
                return Optional.ofNullable(clazz.cast(this.tablesLoading()));
            }
            case "TablesQueued": {
                return Optional.ofNullable(clazz.cast(this.tablesQueued()));
            }
            case "TablesErrored": {
                return Optional.ofNullable(clazz.cast(this.tablesErrored()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationTaskStatsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fullLoadProgressPercent;
        private Long elapsedTimeMillis;
        private Integer tablesLoaded;
        private Integer tablesLoading;
        private Integer tablesQueued;
        private Integer tablesErrored;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskStats model) {
            this.fullLoadProgressPercent(model.fullLoadProgressPercent);
            this.elapsedTimeMillis(model.elapsedTimeMillis);
            this.tablesLoaded(model.tablesLoaded);
            this.tablesLoading(model.tablesLoading);
            this.tablesQueued(model.tablesQueued);
            this.tablesErrored(model.tablesErrored);
        }

        public final Integer getFullLoadProgressPercent() {
            return this.fullLoadProgressPercent;
        }

        @Override
        public final Builder fullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
            return this;
        }

        public final void setFullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
        }

        public final Long getElapsedTimeMillis() {
            return this.elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        public final Integer getTablesLoaded() {
            return this.tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        public final Integer getTablesLoading() {
            return this.tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        public final Integer getTablesQueued() {
            return this.tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        public final Integer getTablesErrored() {
            return this.tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        public ReplicationTaskStats build() {
            return new ReplicationTaskStats(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationTaskStats> {
        public Builder fullLoadProgressPercent(Integer var1);

        public Builder elapsedTimeMillis(Long var1);

        public Builder tablesLoaded(Integer var1);

        public Builder tablesLoading(Integer var1);

        public Builder tablesQueued(Integer var1);

        public Builder tablesErrored(Integer var1);
    }
}

