/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.ReplicationPendingModifiedValuesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationPendingModifiedValues
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicationPendingModifiedValues> {
    private final String replicationInstanceClass;
    private final Integer allocatedStorage;
    private final Boolean multiAZ;
    private final String engineVersion;

    private ReplicationPendingModifiedValues(BuilderImpl builder) {
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
    }

    public String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationPendingModifiedValues)) {
            return false;
        }
        ReplicationPendingModifiedValues other = (ReplicationPendingModifiedValues)obj;
        return Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationPendingModifiedValues").add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationPendingModifiedValuesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationInstanceClass;
        private Integer allocatedStorage;
        private Boolean multiAZ;
        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationPendingModifiedValues model) {
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.allocatedStorage(model.allocatedStorage);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public ReplicationPendingModifiedValues build() {
            return new ReplicationPendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicationPendingModifiedValues> {
        public Builder replicationInstanceClass(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);
    }
}

