/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue;
import software.amazon.awssdk.services.databasemigration.transform.RefreshSchemasStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshSchemasStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, RefreshSchemasStatus> {
    private final String endpointArn;
    private final String replicationInstanceArn;
    private final String status;
    private final Instant lastRefreshDate;
    private final String lastFailureMessage;

    private RefreshSchemasStatus(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.status = builder.status;
        this.lastRefreshDate = builder.lastRefreshDate;
        this.lastFailureMessage = builder.lastFailureMessage;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public RefreshSchemasStatusTypeValue status() {
        return RefreshSchemasStatusTypeValue.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastRefreshDate() {
        return this.lastRefreshDate;
    }

    public String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshSchemasStatus)) {
            return false;
        }
        RefreshSchemasStatus other = (RefreshSchemasStatus)obj;
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastRefreshDate(), other.lastRefreshDate()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage());
    }

    public String toString() {
        return ToString.builder((String)"RefreshSchemasStatus").add("EndpointArn", (Object)this.endpointArn()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("Status", (Object)this.statusAsString()).add("LastRefreshDate", (Object)this.lastRefreshDate()).add("LastFailureMessage", (Object)this.lastFailureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastRefreshDate": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshDate()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RefreshSchemasStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private String replicationInstanceArn;
        private String status;
        private Instant lastRefreshDate;
        private String lastFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshSchemasStatus model) {
            this.endpointArn(model.endpointArn);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.status(model.status);
            this.lastRefreshDate(model.lastRefreshDate);
            this.lastFailureMessage(model.lastFailureMessage);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RefreshSchemasStatusTypeValue status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastRefreshDate() {
            return this.lastRefreshDate;
        }

        @Override
        public final Builder lastRefreshDate(Instant lastRefreshDate) {
            this.lastRefreshDate = lastRefreshDate;
            return this;
        }

        public final void setLastRefreshDate(Instant lastRefreshDate) {
            this.lastRefreshDate = lastRefreshDate;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public RefreshSchemasStatus build() {
            return new RefreshSchemasStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RefreshSchemasStatus> {
        public Builder endpointArn(String var1);

        public Builder replicationInstanceArn(String var1);

        public Builder status(String var1);

        public Builder status(RefreshSchemasStatusTypeValue var1);

        public Builder lastRefreshDate(Instant var1);

        public Builder lastFailureMessage(String var1);
    }
}

