/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.databasemigration.transform.EventCategoryGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventCategoryGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, EventCategoryGroup> {
    private final String sourceType;
    private final List<String> eventCategories;

    private EventCategoryGroup(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoryGroup)) {
            return false;
        }
        EventCategoryGroup other = (EventCategoryGroup)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.eventCategories(), other.eventCategories());
    }

    public String toString() {
        return ToString.builder((String)"EventCategoryGroup").add("SourceType", (Object)this.sourceType()).add("EventCategories", this.eventCategories()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventCategoryGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoryGroup model) {
            this.sourceType(model.sourceType);
            this.eventCategories(model.eventCategories);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public EventCategoryGroup build() {
            return new EventCategoryGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventCategoryGroup> {
        public Builder sourceType(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);
    }
}

