/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.DynamoDbSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDbSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamoDbSettings> {
    private final String serviceAccessRoleArn;

    private DynamoDbSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDbSettings)) {
            return false;
        }
        DynamoDbSettings other = (DynamoDbSettings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"DynamoDbSettings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDbSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDbSettings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public DynamoDbSettings build() {
            return new DynamoDbSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDbSettings> {
        public Builder serviceAccessRoleArn(String var1);
    }
}

