/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.DmsTransferSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DmsTransferSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DmsTransferSettings> {
    private final String serviceAccessRoleArn;
    private final String bucketName;

    private DmsTransferSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.bucketName = builder.bucketName;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DmsTransferSettings)) {
            return false;
        }
        DmsTransferSettings other = (DmsTransferSettings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.bucketName(), other.bucketName());
    }

    public String toString() {
        return ToString.builder((String)"DmsTransferSettings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("BucketName", (Object)this.bucketName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DmsTransferSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String bucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(DmsTransferSettings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.bucketName(model.bucketName);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public DmsTransferSettings build() {
            return new DmsTransferSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DmsTransferSettings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder bucketName(String var1);
    }
}

