/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance;
import software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableReplicationInstancesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeOrderableReplicationInstancesResponse> {
    private final List<OrderableReplicationInstance> orderableReplicationInstances;
    private final String marker;

    private DescribeOrderableReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.orderableReplicationInstances = builder.orderableReplicationInstances;
        this.marker = builder.marker;
    }

    public List<OrderableReplicationInstance> orderableReplicationInstances() {
        return this.orderableReplicationInstances;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderableReplicationInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableReplicationInstancesResponse)) {
            return false;
        }
        DescribeOrderableReplicationInstancesResponse other = (DescribeOrderableReplicationInstancesResponse)((Object)obj);
        return Objects.equals(this.orderableReplicationInstances(), other.orderableReplicationInstances()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrderableReplicationInstancesResponse").add("OrderableReplicationInstances", this.orderableReplicationInstances()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableReplicationInstances": {
                return Optional.ofNullable(clazz.cast(this.orderableReplicationInstances()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<OrderableReplicationInstance> orderableReplicationInstances = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableReplicationInstancesResponse model) {
            super(model);
            this.orderableReplicationInstances(model.orderableReplicationInstances);
            this.marker(model.marker);
        }

        public final Collection<OrderableReplicationInstance.Builder> getOrderableReplicationInstances() {
            return this.orderableReplicationInstances != null ? (Collection)this.orderableReplicationInstances.stream().map(OrderableReplicationInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier.copy(orderableReplicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableReplicationInstances(OrderableReplicationInstance ... orderableReplicationInstances) {
            this.orderableReplicationInstances(Arrays.asList(orderableReplicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableReplicationInstances(Consumer<OrderableReplicationInstance.Builder> ... orderableReplicationInstances) {
            this.orderableReplicationInstances(Stream.of(orderableReplicationInstances).map(c -> (OrderableReplicationInstance)((OrderableReplicationInstance.Builder)OrderableReplicationInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableReplicationInstances(Collection<OrderableReplicationInstance.BuilderImpl> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier.copyFromBuilder(orderableReplicationInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableReplicationInstancesResponse build() {
            return new DescribeOrderableReplicationInstancesResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeOrderableReplicationInstancesResponse> {
        public Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> var1);

        public Builder orderableReplicationInstances(OrderableReplicationInstance ... var1);

        public Builder orderableReplicationInstances(Consumer<OrderableReplicationInstance.Builder> ... var1);

        public Builder marker(String var1);
    }
}

