/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.Endpoint;
import software.amazon.awssdk.services.databasemigration.model.EndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEndpointsResponse> {
    private final String marker;
    private final List<Endpoint> endpoints;

    private DescribeEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.endpoints = builder.endpoints;
    }

    public String marker() {
        return this.marker;
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointsResponse)) {
            return false;
        }
        DescribeEndpointsResponse other = (DescribeEndpointsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.endpoints(), other.endpoints());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEndpointsResponse").add("Marker", (Object)this.marker()).add("Endpoints", this.endpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointsResponse model) {
            super(model);
            this.marker(model.marker);
            this.endpoints(model.endpoints);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Endpoint.Builder> getEndpoints() {
            return this.endpoints != null ? (Collection)this.endpoints.stream().map(Endpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public DescribeEndpointsResponse build() {
            return new DescribeEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeEndpointsResponse> {
        public Builder marker(String var1);

        public Builder endpoints(Collection<Endpoint> var1);

        public Builder endpoints(Endpoint ... var1);

        public Builder endpoints(Consumer<Endpoint.Builder> ... var1);
    }
}

