/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.ConnectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connection
implements StructuredPojo,
ToCopyableBuilder<Builder, Connection> {
    private final String replicationInstanceArn;
    private final String endpointArn;
    private final String status;
    private final String lastFailureMessage;
    private final String endpointIdentifier;
    private final String replicationInstanceIdentifier;

    private Connection(BuilderImpl builder) {
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String status() {
        return this.status;
    }

    public String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"Connection").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("EndpointArn", (Object)this.endpointArn()).add("Status", (Object)this.status()).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "EndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private String endpointArn;
        private String status;
        private String lastFailureMessage;
        private String endpointIdentifier;
        private String replicationInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.endpointArn(model.endpointArn);
            this.status(model.status);
            this.lastFailureMessage(model.lastFailureMessage);
            this.endpointIdentifier(model.endpointIdentifier);
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        public Connection build() {
            return new Connection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Connection> {
        public Builder replicationInstanceArn(String var1);

        public Builder endpointArn(String var1);

        public Builder status(String var1);

        public Builder lastFailureMessage(String var1);

        public Builder endpointIdentifier(String var1);

        public Builder replicationInstanceIdentifier(String var1);
    }
}

