/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.transform.CertificateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements StructuredPojo,
ToCopyableBuilder<Builder, Certificate> {
    private final String certificateIdentifier;
    private final Instant certificateCreationDate;
    private final String certificatePem;
    private final SdkBytes certificateWallet;
    private final String certificateArn;
    private final String certificateOwner;
    private final Instant validFromDate;
    private final Instant validToDate;
    private final String signingAlgorithm;
    private final Integer keyLength;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateCreationDate = builder.certificateCreationDate;
        this.certificatePem = builder.certificatePem;
        this.certificateWallet = builder.certificateWallet;
        this.certificateArn = builder.certificateArn;
        this.certificateOwner = builder.certificateOwner;
        this.validFromDate = builder.validFromDate;
        this.validToDate = builder.validToDate;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.keyLength = builder.keyLength;
    }

    public String certificateIdentifier() {
        return this.certificateIdentifier;
    }

    public Instant certificateCreationDate() {
        return this.certificateCreationDate;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public SdkBytes certificateWallet() {
        return this.certificateWallet;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateOwner() {
        return this.certificateOwner;
    }

    public Instant validFromDate() {
        return this.validFromDate;
    }

    public Instant validToDate() {
        return this.validToDate;
    }

    public String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    public Integer keyLength() {
        return this.keyLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateWallet());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFromDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validToDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.certificateIdentifier(), other.certificateIdentifier()) && Objects.equals(this.certificateCreationDate(), other.certificateCreationDate()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.certificateWallet(), other.certificateWallet()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateOwner(), other.certificateOwner()) && Objects.equals(this.validFromDate(), other.validFromDate()) && Objects.equals(this.validToDate(), other.validToDate()) && Objects.equals(this.signingAlgorithm(), other.signingAlgorithm()) && Objects.equals(this.keyLength(), other.keyLength());
    }

    public String toString() {
        return ToString.builder((String)"Certificate").add("CertificateIdentifier", (Object)this.certificateIdentifier()).add("CertificateCreationDate", (Object)this.certificateCreationDate()).add("CertificatePem", (Object)this.certificatePem()).add("CertificateWallet", (Object)this.certificateWallet()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateOwner", (Object)this.certificateOwner()).add("ValidFromDate", (Object)this.validFromDate()).add("ValidToDate", (Object)this.validToDate()).add("SigningAlgorithm", (Object)this.signingAlgorithm()).add("KeyLength", (Object)this.keyLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateIdentifier()));
            }
            case "CertificateCreationDate": {
                return Optional.ofNullable(clazz.cast(this.certificateCreationDate()));
            }
            case "CertificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "CertificateWallet": {
                return Optional.ofNullable(clazz.cast(this.certificateWallet()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "CertificateOwner": {
                return Optional.ofNullable(clazz.cast(this.certificateOwner()));
            }
            case "ValidFromDate": {
                return Optional.ofNullable(clazz.cast(this.validFromDate()));
            }
            case "ValidToDate": {
                return Optional.ofNullable(clazz.cast(this.validToDate()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithm()));
            }
            case "KeyLength": {
                return Optional.ofNullable(clazz.cast(this.keyLength()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateIdentifier;
        private Instant certificateCreationDate;
        private String certificatePem;
        private SdkBytes certificateWallet;
        private String certificateArn;
        private String certificateOwner;
        private Instant validFromDate;
        private Instant validToDate;
        private String signingAlgorithm;
        private Integer keyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.certificateIdentifier(model.certificateIdentifier);
            this.certificateCreationDate(model.certificateCreationDate);
            this.certificatePem(model.certificatePem);
            this.certificateWallet(model.certificateWallet);
            this.certificateArn(model.certificateArn);
            this.certificateOwner(model.certificateOwner);
            this.validFromDate(model.validFromDate);
            this.validToDate(model.validToDate);
            this.signingAlgorithm(model.signingAlgorithm);
            this.keyLength(model.keyLength);
        }

        public final String getCertificateIdentifier() {
            return this.certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final Instant getCertificateCreationDate() {
            return this.certificateCreationDate;
        }

        @Override
        public final Builder certificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
            return this;
        }

        public final void setCertificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final ByteBuffer getCertificateWallet() {
            return this.certificateWallet == null ? null : this.certificateWallet.asByteBuffer();
        }

        @Override
        public final Builder certificateWallet(SdkBytes certificateWallet) {
            this.certificateWallet = StandardMemberCopier.copy((SdkBytes)certificateWallet);
            return this;
        }

        public final void setCertificateWallet(ByteBuffer certificateWallet) {
            this.certificateWallet(certificateWallet == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificateWallet));
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateOwner() {
            return this.certificateOwner;
        }

        @Override
        public final Builder certificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
            return this;
        }

        public final void setCertificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
        }

        public final Instant getValidFromDate() {
            return this.validFromDate;
        }

        @Override
        public final Builder validFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
            return this;
        }

        public final void setValidFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
        }

        public final Instant getValidToDate() {
            return this.validToDate;
        }

        @Override
        public final Builder validToDate(Instant validToDate) {
            this.validToDate = validToDate;
            return this;
        }

        public final void setValidToDate(Instant validToDate) {
            this.validToDate = validToDate;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public final Integer getKeyLength() {
            return this.keyLength;
        }

        @Override
        public final Builder keyLength(Integer keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        public final void setKeyLength(Integer keyLength) {
            this.keyLength = keyLength;
        }

        public Certificate build() {
            return new Certificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Certificate> {
        public Builder certificateIdentifier(String var1);

        public Builder certificateCreationDate(Instant var1);

        public Builder certificatePem(String var1);

        public Builder certificateWallet(SdkBytes var1);

        public Builder certificateArn(String var1);

        public Builder certificateOwner(String var1);

        public Builder validFromDate(Instant var1);

        public Builder validToDate(Instant var1);

        public Builder signingAlgorithm(String var1);

        public Builder keyLength(Integer var1);
    }
}

