/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetDomainResponse.Builder, GetDomainResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetDomainResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultExpirationDays").getter(getter(GetDomainResponse::defaultExpirationDays))
            .setter(setter(Builder::defaultExpirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build())
            .build();

    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultEncryptionKey").getter(getter(GetDomainResponse::defaultEncryptionKey))
            .setter(setter(Builder::defaultEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build())
            .build();

    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeadLetterQueueUrl").getter(getter(GetDomainResponse::deadLetterQueueUrl))
            .setter(setter(Builder::deadLetterQueueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build())
            .build();

    private static final SdkField<DomainStats> STATS_FIELD = SdkField.<DomainStats> builder(MarshallingType.SDK_POJO)
            .memberName("Stats").getter(getter(GetDomainResponse::stats)).setter(setter(Builder::stats))
            .constructor(DomainStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stats").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetDomainResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetDomainResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetDomainResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, STATS_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));

    private final String domainName;

    private final Integer defaultExpirationDays;

    private final String defaultEncryptionKey;

    private final String deadLetterQueueUrl;

    private final DomainStats stats;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private GetDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.stats = builder.stats;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The default number of days until the data within the domain expires.
     * </p>
     * 
     * @return The default number of days until the data within the domain expires.
     */
    public final Integer defaultExpirationDays() {
        return defaultExpirationDays;
    }

    /**
     * <p>
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
     * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     * </p>
     * 
     * @return The default encryption key, which is an AWS managed key, is used when no specific type of encryption key
     *         is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    public final String defaultEncryptionKey() {
        return defaultEncryptionKey;
    }

    /**
     * <p>
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
     * third party applications.
     * </p>
     * 
     * @return The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data
     *         from third party applications.
     */
    public final String deadLetterQueueUrl() {
        return deadLetterQueueUrl;
    }

    /**
     * <p>
     * Usage-specific statistics about the domain.
     * </p>
     * 
     * @return Usage-specific statistics about the domain.
     */
    public final DomainStats stats() {
        return stats;
    }

    /**
     * <p>
     * The timestamp of when the domain was created.
     * </p>
     * 
     * @return The timestamp of when the domain was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the domain was most recently edited.
     * </p>
     * 
     * @return The timestamp of when the domain was most recently edited.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(stats());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainResponse)) {
            return false;
        }
        GetDomainResponse other = (GetDomainResponse) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(defaultExpirationDays(), other.defaultExpirationDays())
                && Objects.equals(defaultEncryptionKey(), other.defaultEncryptionKey())
                && Objects.equals(deadLetterQueueUrl(), other.deadLetterQueueUrl()) && Objects.equals(stats(), other.stats())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainResponse").add("DomainName", domainName())
                .add("DefaultExpirationDays", defaultExpirationDays()).add("DefaultEncryptionKey", defaultEncryptionKey())
                .add("DeadLetterQueueUrl", deadLetterQueueUrl()).add("Stats", stats()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DefaultExpirationDays":
            return Optional.ofNullable(clazz.cast(defaultExpirationDays()));
        case "DefaultEncryptionKey":
            return Optional.ofNullable(clazz.cast(defaultEncryptionKey()));
        case "DeadLetterQueueUrl":
            return Optional.ofNullable(clazz.cast(deadLetterQueueUrl()));
        case "Stats":
            return Optional.ofNullable(clazz.cast(stats()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainResponse, T> g) {
        return obj -> g.apply((GetDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDomainResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The default number of days until the data within the domain expires.
         * </p>
         * 
         * @param defaultExpirationDays
         *        The default number of days until the data within the domain expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExpirationDays(Integer defaultExpirationDays);

        /**
         * <p>
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
         * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         * </p>
         * 
         * @param defaultEncryptionKey
         *        The default encryption key, which is an AWS managed key, is used when no specific type of encryption
         *        key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEncryptionKey(String defaultEncryptionKey);

        /**
         * <p>
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
         * third party applications.
         * </p>
         * 
         * @param deadLetterQueueUrl
         *        The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting
         *        data from third party applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterQueueUrl(String deadLetterQueueUrl);

        /**
         * <p>
         * Usage-specific statistics about the domain.
         * </p>
         * 
         * @param stats
         *        Usage-specific statistics about the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stats(DomainStats stats);

        /**
         * <p>
         * Usage-specific statistics about the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainStats.Builder} avoiding the need to create
         * one manually via {@link DomainStats#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainStats.Builder#build()} is called immediately and its result
         * is passed to {@link #stats(DomainStats)}.
         * 
         * @param stats
         *        a consumer that will call methods on {@link DomainStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stats(DomainStats)
         */
        default Builder stats(Consumer<DomainStats.Builder> stats) {
            return stats(DomainStats.builder().applyMutation(stats).build());
        }

        /**
         * <p>
         * The timestamp of when the domain was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the domain was most recently edited.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the domain was most recently edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private Integer defaultExpirationDays;

        private String defaultEncryptionKey;

        private String deadLetterQueueUrl;

        private DomainStats stats;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainResponse model) {
            super(model);
            domainName(model.domainName);
            defaultExpirationDays(model.defaultExpirationDays);
            defaultEncryptionKey(model.defaultEncryptionKey);
            deadLetterQueueUrl(model.deadLetterQueueUrl);
            stats(model.stats);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDefaultExpirationDays() {
            return defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        public final String getDefaultEncryptionKey() {
            return defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        public final String getDeadLetterQueueUrl() {
            return deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        public final DomainStats.Builder getStats() {
            return stats != null ? stats.toBuilder() : null;
        }

        @Override
        public final Builder stats(DomainStats stats) {
            this.stats = stats;
            return this;
        }

        public final void setStats(DomainStats.BuilderImpl stats) {
            this.stats = stats != null ? stats.build() : null;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetDomainResponse build() {
            return new GetDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
