/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costoptimizationhub.model.AuroraDbClusterStorage;
import software.amazon.awssdk.services.costoptimizationhub.model.ComputeSavingsPlans;
import software.amazon.awssdk.services.costoptimizationhub.model.DynamoDbReservedCapacity;
import software.amazon.awssdk.services.costoptimizationhub.model.EbsVolume;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2AutoScalingGroup;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2Instance;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2InstanceSavingsPlans;
import software.amazon.awssdk.services.costoptimizationhub.model.Ec2ReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.EcsService;
import software.amazon.awssdk.services.costoptimizationhub.model.ElastiCacheReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.LambdaFunction;
import software.amazon.awssdk.services.costoptimizationhub.model.MemoryDbReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.NatGateway;
import software.amazon.awssdk.services.costoptimizationhub.model.OpenSearchReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.RdsDbInstance;
import software.amazon.awssdk.services.costoptimizationhub.model.RdsDbInstanceStorage;
import software.amazon.awssdk.services.costoptimizationhub.model.RdsReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.RedshiftReservedInstances;
import software.amazon.awssdk.services.costoptimizationhub.model.SageMakerSavingsPlans;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetails> {
    private static final SdkField<LambdaFunction> LAMBDA_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaFunction").getter(ResourceDetails.getter(ResourceDetails::lambdaFunction)).setter(ResourceDetails.setter(Builder::lambdaFunction)).constructor(LambdaFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()}).build();
    private static final SdkField<EcsService> ECS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsService").getter(ResourceDetails.getter(ResourceDetails::ecsService)).setter(ResourceDetails.setter(Builder::ecsService)).constructor(EcsService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsService").build()}).build();
    private static final SdkField<Ec2Instance> EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2Instance").getter(ResourceDetails.getter(ResourceDetails::ec2Instance)).setter(ResourceDetails.setter(Builder::ec2Instance)).constructor(Ec2Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Instance").build()}).build();
    private static final SdkField<EbsVolume> EBS_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ebsVolume").getter(ResourceDetails.getter(ResourceDetails::ebsVolume)).setter(ResourceDetails.setter(Builder::ebsVolume)).constructor(EbsVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolume").build()}).build();
    private static final SdkField<Ec2AutoScalingGroup> EC2_AUTO_SCALING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2AutoScalingGroup").getter(ResourceDetails.getter(ResourceDetails::ec2AutoScalingGroup)).setter(ResourceDetails.setter(Builder::ec2AutoScalingGroup)).constructor(Ec2AutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2AutoScalingGroup").build()}).build();
    private static final SdkField<Ec2ReservedInstances> EC2_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2ReservedInstances").getter(ResourceDetails.getter(ResourceDetails::ec2ReservedInstances)).setter(ResourceDetails.setter(Builder::ec2ReservedInstances)).constructor(Ec2ReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2ReservedInstances").build()}).build();
    private static final SdkField<RdsReservedInstances> RDS_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsReservedInstances").getter(ResourceDetails.getter(ResourceDetails::rdsReservedInstances)).setter(ResourceDetails.setter(Builder::rdsReservedInstances)).constructor(RdsReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsReservedInstances").build()}).build();
    private static final SdkField<ElastiCacheReservedInstances> ELASTI_CACHE_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elastiCacheReservedInstances").getter(ResourceDetails.getter(ResourceDetails::elastiCacheReservedInstances)).setter(ResourceDetails.setter(Builder::elastiCacheReservedInstances)).constructor(ElastiCacheReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elastiCacheReservedInstances").build()}).build();
    private static final SdkField<OpenSearchReservedInstances> OPEN_SEARCH_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openSearchReservedInstances").getter(ResourceDetails.getter(ResourceDetails::openSearchReservedInstances)).setter(ResourceDetails.setter(Builder::openSearchReservedInstances)).constructor(OpenSearchReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchReservedInstances").build()}).build();
    private static final SdkField<RedshiftReservedInstances> REDSHIFT_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftReservedInstances").getter(ResourceDetails.getter(ResourceDetails::redshiftReservedInstances)).setter(ResourceDetails.setter(Builder::redshiftReservedInstances)).constructor(RedshiftReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftReservedInstances").build()}).build();
    private static final SdkField<Ec2InstanceSavingsPlans> EC2_INSTANCE_SAVINGS_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2InstanceSavingsPlans").getter(ResourceDetails.getter(ResourceDetails::ec2InstanceSavingsPlans)).setter(ResourceDetails.setter(Builder::ec2InstanceSavingsPlans)).constructor(Ec2InstanceSavingsPlans::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceSavingsPlans").build()}).build();
    private static final SdkField<ComputeSavingsPlans> COMPUTE_SAVINGS_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeSavingsPlans").getter(ResourceDetails.getter(ResourceDetails::computeSavingsPlans)).setter(ResourceDetails.setter(Builder::computeSavingsPlans)).constructor(ComputeSavingsPlans::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeSavingsPlans").build()}).build();
    private static final SdkField<SageMakerSavingsPlans> SAGE_MAKER_SAVINGS_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sageMakerSavingsPlans").getter(ResourceDetails.getter(ResourceDetails::sageMakerSavingsPlans)).setter(ResourceDetails.setter(Builder::sageMakerSavingsPlans)).constructor(SageMakerSavingsPlans::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerSavingsPlans").build()}).build();
    private static final SdkField<RdsDbInstance> RDS_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsDbInstance").getter(ResourceDetails.getter(ResourceDetails::rdsDbInstance)).setter(ResourceDetails.setter(Builder::rdsDbInstance)).constructor(RdsDbInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbInstance").build()}).build();
    private static final SdkField<RdsDbInstanceStorage> RDS_DB_INSTANCE_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsDbInstanceStorage").getter(ResourceDetails.getter(ResourceDetails::rdsDbInstanceStorage)).setter(ResourceDetails.setter(Builder::rdsDbInstanceStorage)).constructor(RdsDbInstanceStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbInstanceStorage").build()}).build();
    private static final SdkField<AuroraDbClusterStorage> AURORA_DB_CLUSTER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("auroraDbClusterStorage").getter(ResourceDetails.getter(ResourceDetails::auroraDbClusterStorage)).setter(ResourceDetails.setter(Builder::auroraDbClusterStorage)).constructor(AuroraDbClusterStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auroraDbClusterStorage").build()}).build();
    private static final SdkField<DynamoDbReservedCapacity> DYNAMO_DB_RESERVED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamoDbReservedCapacity").getter(ResourceDetails.getter(ResourceDetails::dynamoDbReservedCapacity)).setter(ResourceDetails.setter(Builder::dynamoDbReservedCapacity)).constructor(DynamoDbReservedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDbReservedCapacity").build()}).build();
    private static final SdkField<MemoryDbReservedInstances> MEMORY_DB_RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryDbReservedInstances").getter(ResourceDetails.getter(ResourceDetails::memoryDbReservedInstances)).setter(ResourceDetails.setter(Builder::memoryDbReservedInstances)).constructor(MemoryDbReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryDbReservedInstances").build()}).build();
    private static final SdkField<NatGateway> NAT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("natGateway").getter(ResourceDetails.getter(ResourceDetails::natGateway)).setter(ResourceDetails.setter(Builder::natGateway)).constructor(NatGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("natGateway").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_FIELD, ECS_SERVICE_FIELD, EC2_INSTANCE_FIELD, EBS_VOLUME_FIELD, EC2_AUTO_SCALING_GROUP_FIELD, EC2_RESERVED_INSTANCES_FIELD, RDS_RESERVED_INSTANCES_FIELD, ELASTI_CACHE_RESERVED_INSTANCES_FIELD, OPEN_SEARCH_RESERVED_INSTANCES_FIELD, REDSHIFT_RESERVED_INSTANCES_FIELD, EC2_INSTANCE_SAVINGS_PLANS_FIELD, COMPUTE_SAVINGS_PLANS_FIELD, SAGE_MAKER_SAVINGS_PLANS_FIELD, RDS_DB_INSTANCE_FIELD, RDS_DB_INSTANCE_STORAGE_FIELD, AURORA_DB_CLUSTER_STORAGE_FIELD, DYNAMO_DB_RESERVED_CAPACITY_FIELD, MEMORY_DB_RESERVED_INSTANCES_FIELD, NAT_GATEWAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LambdaFunction lambdaFunction;
    private final EcsService ecsService;
    private final Ec2Instance ec2Instance;
    private final EbsVolume ebsVolume;
    private final Ec2AutoScalingGroup ec2AutoScalingGroup;
    private final Ec2ReservedInstances ec2ReservedInstances;
    private final RdsReservedInstances rdsReservedInstances;
    private final ElastiCacheReservedInstances elastiCacheReservedInstances;
    private final OpenSearchReservedInstances openSearchReservedInstances;
    private final RedshiftReservedInstances redshiftReservedInstances;
    private final Ec2InstanceSavingsPlans ec2InstanceSavingsPlans;
    private final ComputeSavingsPlans computeSavingsPlans;
    private final SageMakerSavingsPlans sageMakerSavingsPlans;
    private final RdsDbInstance rdsDbInstance;
    private final RdsDbInstanceStorage rdsDbInstanceStorage;
    private final AuroraDbClusterStorage auroraDbClusterStorage;
    private final DynamoDbReservedCapacity dynamoDbReservedCapacity;
    private final MemoryDbReservedInstances memoryDbReservedInstances;
    private final NatGateway natGateway;
    private final Type type;

    private ResourceDetails(BuilderImpl builder) {
        this.lambdaFunction = builder.lambdaFunction;
        this.ecsService = builder.ecsService;
        this.ec2Instance = builder.ec2Instance;
        this.ebsVolume = builder.ebsVolume;
        this.ec2AutoScalingGroup = builder.ec2AutoScalingGroup;
        this.ec2ReservedInstances = builder.ec2ReservedInstances;
        this.rdsReservedInstances = builder.rdsReservedInstances;
        this.elastiCacheReservedInstances = builder.elastiCacheReservedInstances;
        this.openSearchReservedInstances = builder.openSearchReservedInstances;
        this.redshiftReservedInstances = builder.redshiftReservedInstances;
        this.ec2InstanceSavingsPlans = builder.ec2InstanceSavingsPlans;
        this.computeSavingsPlans = builder.computeSavingsPlans;
        this.sageMakerSavingsPlans = builder.sageMakerSavingsPlans;
        this.rdsDbInstance = builder.rdsDbInstance;
        this.rdsDbInstanceStorage = builder.rdsDbInstanceStorage;
        this.auroraDbClusterStorage = builder.auroraDbClusterStorage;
        this.dynamoDbReservedCapacity = builder.dynamoDbReservedCapacity;
        this.memoryDbReservedInstances = builder.memoryDbReservedInstances;
        this.natGateway = builder.natGateway;
        this.type = builder.type;
    }

    public final LambdaFunction lambdaFunction() {
        return this.lambdaFunction;
    }

    public final EcsService ecsService() {
        return this.ecsService;
    }

    public final Ec2Instance ec2Instance() {
        return this.ec2Instance;
    }

    public final EbsVolume ebsVolume() {
        return this.ebsVolume;
    }

    public final Ec2AutoScalingGroup ec2AutoScalingGroup() {
        return this.ec2AutoScalingGroup;
    }

    public final Ec2ReservedInstances ec2ReservedInstances() {
        return this.ec2ReservedInstances;
    }

    public final RdsReservedInstances rdsReservedInstances() {
        return this.rdsReservedInstances;
    }

    public final ElastiCacheReservedInstances elastiCacheReservedInstances() {
        return this.elastiCacheReservedInstances;
    }

    public final OpenSearchReservedInstances openSearchReservedInstances() {
        return this.openSearchReservedInstances;
    }

    public final RedshiftReservedInstances redshiftReservedInstances() {
        return this.redshiftReservedInstances;
    }

    public final Ec2InstanceSavingsPlans ec2InstanceSavingsPlans() {
        return this.ec2InstanceSavingsPlans;
    }

    public final ComputeSavingsPlans computeSavingsPlans() {
        return this.computeSavingsPlans;
    }

    public final SageMakerSavingsPlans sageMakerSavingsPlans() {
        return this.sageMakerSavingsPlans;
    }

    public final RdsDbInstance rdsDbInstance() {
        return this.rdsDbInstance;
    }

    public final RdsDbInstanceStorage rdsDbInstanceStorage() {
        return this.rdsDbInstanceStorage;
    }

    public final AuroraDbClusterStorage auroraDbClusterStorage() {
        return this.auroraDbClusterStorage;
    }

    public final DynamoDbReservedCapacity dynamoDbReservedCapacity() {
        return this.dynamoDbReservedCapacity;
    }

    public final MemoryDbReservedInstances memoryDbReservedInstances() {
        return this.memoryDbReservedInstances;
    }

    public final NatGateway natGateway() {
        return this.natGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AutoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.elastiCacheReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.openSearchReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.auroraDbClusterStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDbReservedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryDbReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGateway());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails)obj;
        return Objects.equals(this.lambdaFunction(), other.lambdaFunction()) && Objects.equals(this.ecsService(), other.ecsService()) && Objects.equals(this.ec2Instance(), other.ec2Instance()) && Objects.equals(this.ebsVolume(), other.ebsVolume()) && Objects.equals(this.ec2AutoScalingGroup(), other.ec2AutoScalingGroup()) && Objects.equals(this.ec2ReservedInstances(), other.ec2ReservedInstances()) && Objects.equals(this.rdsReservedInstances(), other.rdsReservedInstances()) && Objects.equals(this.elastiCacheReservedInstances(), other.elastiCacheReservedInstances()) && Objects.equals(this.openSearchReservedInstances(), other.openSearchReservedInstances()) && Objects.equals(this.redshiftReservedInstances(), other.redshiftReservedInstances()) && Objects.equals(this.ec2InstanceSavingsPlans(), other.ec2InstanceSavingsPlans()) && Objects.equals(this.computeSavingsPlans(), other.computeSavingsPlans()) && Objects.equals(this.sageMakerSavingsPlans(), other.sageMakerSavingsPlans()) && Objects.equals(this.rdsDbInstance(), other.rdsDbInstance()) && Objects.equals(this.rdsDbInstanceStorage(), other.rdsDbInstanceStorage()) && Objects.equals(this.auroraDbClusterStorage(), other.auroraDbClusterStorage()) && Objects.equals(this.dynamoDbReservedCapacity(), other.dynamoDbReservedCapacity()) && Objects.equals(this.memoryDbReservedInstances(), other.memoryDbReservedInstances()) && Objects.equals(this.natGateway(), other.natGateway());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDetails").add("LambdaFunction", (Object)this.lambdaFunction()).add("EcsService", (Object)this.ecsService()).add("Ec2Instance", (Object)this.ec2Instance()).add("EbsVolume", (Object)this.ebsVolume()).add("Ec2AutoScalingGroup", (Object)this.ec2AutoScalingGroup()).add("Ec2ReservedInstances", (Object)this.ec2ReservedInstances()).add("RdsReservedInstances", (Object)this.rdsReservedInstances()).add("ElastiCacheReservedInstances", (Object)this.elastiCacheReservedInstances()).add("OpenSearchReservedInstances", (Object)this.openSearchReservedInstances()).add("RedshiftReservedInstances", (Object)this.redshiftReservedInstances()).add("Ec2InstanceSavingsPlans", (Object)this.ec2InstanceSavingsPlans()).add("ComputeSavingsPlans", (Object)this.computeSavingsPlans()).add("SageMakerSavingsPlans", (Object)this.sageMakerSavingsPlans()).add("RdsDbInstance", (Object)this.rdsDbInstance()).add("RdsDbInstanceStorage", (Object)this.rdsDbInstanceStorage()).add("AuroraDbClusterStorage", (Object)this.auroraDbClusterStorage()).add("DynamoDbReservedCapacity", (Object)this.dynamoDbReservedCapacity()).add("MemoryDbReservedInstances", (Object)this.memoryDbReservedInstances()).add("NatGateway", (Object)this.natGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambdaFunction": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunction()));
            }
            case "ecsService": {
                return Optional.ofNullable(clazz.cast(this.ecsService()));
            }
            case "ec2Instance": {
                return Optional.ofNullable(clazz.cast(this.ec2Instance()));
            }
            case "ebsVolume": {
                return Optional.ofNullable(clazz.cast(this.ebsVolume()));
            }
            case "ec2AutoScalingGroup": {
                return Optional.ofNullable(clazz.cast(this.ec2AutoScalingGroup()));
            }
            case "ec2ReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.ec2ReservedInstances()));
            }
            case "rdsReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.rdsReservedInstances()));
            }
            case "elastiCacheReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.elastiCacheReservedInstances()));
            }
            case "openSearchReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.openSearchReservedInstances()));
            }
            case "redshiftReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.redshiftReservedInstances()));
            }
            case "ec2InstanceSavingsPlans": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceSavingsPlans()));
            }
            case "computeSavingsPlans": {
                return Optional.ofNullable(clazz.cast(this.computeSavingsPlans()));
            }
            case "sageMakerSavingsPlans": {
                return Optional.ofNullable(clazz.cast(this.sageMakerSavingsPlans()));
            }
            case "rdsDbInstance": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstance()));
            }
            case "rdsDbInstanceStorage": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceStorage()));
            }
            case "auroraDbClusterStorage": {
                return Optional.ofNullable(clazz.cast(this.auroraDbClusterStorage()));
            }
            case "dynamoDbReservedCapacity": {
                return Optional.ofNullable(clazz.cast(this.dynamoDbReservedCapacity()));
            }
            case "memoryDbReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.memoryDbReservedInstances()));
            }
            case "natGateway": {
                return Optional.ofNullable(clazz.cast(this.natGateway()));
            }
        }
        return Optional.empty();
    }

    public static ResourceDetails fromLambdaFunction(LambdaFunction lambdaFunction) {
        return (ResourceDetails)ResourceDetails.builder().lambdaFunction(lambdaFunction).build();
    }

    public static ResourceDetails fromLambdaFunction(Consumer<LambdaFunction.Builder> lambdaFunction) {
        LambdaFunction.Builder builder = LambdaFunction.builder();
        lambdaFunction.accept(builder);
        return ResourceDetails.fromLambdaFunction((LambdaFunction)builder.build());
    }

    public static ResourceDetails fromEcsService(EcsService ecsService) {
        return (ResourceDetails)ResourceDetails.builder().ecsService(ecsService).build();
    }

    public static ResourceDetails fromEcsService(Consumer<EcsService.Builder> ecsService) {
        EcsService.Builder builder = EcsService.builder();
        ecsService.accept(builder);
        return ResourceDetails.fromEcsService((EcsService)builder.build());
    }

    public static ResourceDetails fromEc2Instance(Ec2Instance ec2Instance) {
        return (ResourceDetails)ResourceDetails.builder().ec2Instance(ec2Instance).build();
    }

    public static ResourceDetails fromEc2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
        Ec2Instance.Builder builder = Ec2Instance.builder();
        ec2Instance.accept(builder);
        return ResourceDetails.fromEc2Instance((Ec2Instance)builder.build());
    }

    public static ResourceDetails fromEbsVolume(EbsVolume ebsVolume) {
        return (ResourceDetails)ResourceDetails.builder().ebsVolume(ebsVolume).build();
    }

    public static ResourceDetails fromEbsVolume(Consumer<EbsVolume.Builder> ebsVolume) {
        EbsVolume.Builder builder = EbsVolume.builder();
        ebsVolume.accept(builder);
        return ResourceDetails.fromEbsVolume((EbsVolume)builder.build());
    }

    public static ResourceDetails fromEc2AutoScalingGroup(Ec2AutoScalingGroup ec2AutoScalingGroup) {
        return (ResourceDetails)ResourceDetails.builder().ec2AutoScalingGroup(ec2AutoScalingGroup).build();
    }

    public static ResourceDetails fromEc2AutoScalingGroup(Consumer<Ec2AutoScalingGroup.Builder> ec2AutoScalingGroup) {
        Ec2AutoScalingGroup.Builder builder = Ec2AutoScalingGroup.builder();
        ec2AutoScalingGroup.accept(builder);
        return ResourceDetails.fromEc2AutoScalingGroup((Ec2AutoScalingGroup)builder.build());
    }

    public static ResourceDetails fromEc2ReservedInstances(Ec2ReservedInstances ec2ReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().ec2ReservedInstances(ec2ReservedInstances).build();
    }

    public static ResourceDetails fromEc2ReservedInstances(Consumer<Ec2ReservedInstances.Builder> ec2ReservedInstances) {
        Ec2ReservedInstances.Builder builder = Ec2ReservedInstances.builder();
        ec2ReservedInstances.accept(builder);
        return ResourceDetails.fromEc2ReservedInstances((Ec2ReservedInstances)builder.build());
    }

    public static ResourceDetails fromRdsReservedInstances(RdsReservedInstances rdsReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().rdsReservedInstances(rdsReservedInstances).build();
    }

    public static ResourceDetails fromRdsReservedInstances(Consumer<RdsReservedInstances.Builder> rdsReservedInstances) {
        RdsReservedInstances.Builder builder = RdsReservedInstances.builder();
        rdsReservedInstances.accept(builder);
        return ResourceDetails.fromRdsReservedInstances((RdsReservedInstances)builder.build());
    }

    public static ResourceDetails fromElastiCacheReservedInstances(ElastiCacheReservedInstances elastiCacheReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().elastiCacheReservedInstances(elastiCacheReservedInstances).build();
    }

    public static ResourceDetails fromElastiCacheReservedInstances(Consumer<ElastiCacheReservedInstances.Builder> elastiCacheReservedInstances) {
        ElastiCacheReservedInstances.Builder builder = ElastiCacheReservedInstances.builder();
        elastiCacheReservedInstances.accept(builder);
        return ResourceDetails.fromElastiCacheReservedInstances((ElastiCacheReservedInstances)builder.build());
    }

    public static ResourceDetails fromOpenSearchReservedInstances(OpenSearchReservedInstances openSearchReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().openSearchReservedInstances(openSearchReservedInstances).build();
    }

    public static ResourceDetails fromOpenSearchReservedInstances(Consumer<OpenSearchReservedInstances.Builder> openSearchReservedInstances) {
        OpenSearchReservedInstances.Builder builder = OpenSearchReservedInstances.builder();
        openSearchReservedInstances.accept(builder);
        return ResourceDetails.fromOpenSearchReservedInstances((OpenSearchReservedInstances)builder.build());
    }

    public static ResourceDetails fromRedshiftReservedInstances(RedshiftReservedInstances redshiftReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().redshiftReservedInstances(redshiftReservedInstances).build();
    }

    public static ResourceDetails fromRedshiftReservedInstances(Consumer<RedshiftReservedInstances.Builder> redshiftReservedInstances) {
        RedshiftReservedInstances.Builder builder = RedshiftReservedInstances.builder();
        redshiftReservedInstances.accept(builder);
        return ResourceDetails.fromRedshiftReservedInstances((RedshiftReservedInstances)builder.build());
    }

    public static ResourceDetails fromEc2InstanceSavingsPlans(Ec2InstanceSavingsPlans ec2InstanceSavingsPlans) {
        return (ResourceDetails)ResourceDetails.builder().ec2InstanceSavingsPlans(ec2InstanceSavingsPlans).build();
    }

    public static ResourceDetails fromEc2InstanceSavingsPlans(Consumer<Ec2InstanceSavingsPlans.Builder> ec2InstanceSavingsPlans) {
        Ec2InstanceSavingsPlans.Builder builder = Ec2InstanceSavingsPlans.builder();
        ec2InstanceSavingsPlans.accept(builder);
        return ResourceDetails.fromEc2InstanceSavingsPlans((Ec2InstanceSavingsPlans)builder.build());
    }

    public static ResourceDetails fromComputeSavingsPlans(ComputeSavingsPlans computeSavingsPlans) {
        return (ResourceDetails)ResourceDetails.builder().computeSavingsPlans(computeSavingsPlans).build();
    }

    public static ResourceDetails fromComputeSavingsPlans(Consumer<ComputeSavingsPlans.Builder> computeSavingsPlans) {
        ComputeSavingsPlans.Builder builder = ComputeSavingsPlans.builder();
        computeSavingsPlans.accept(builder);
        return ResourceDetails.fromComputeSavingsPlans((ComputeSavingsPlans)builder.build());
    }

    public static ResourceDetails fromSageMakerSavingsPlans(SageMakerSavingsPlans sageMakerSavingsPlans) {
        return (ResourceDetails)ResourceDetails.builder().sageMakerSavingsPlans(sageMakerSavingsPlans).build();
    }

    public static ResourceDetails fromSageMakerSavingsPlans(Consumer<SageMakerSavingsPlans.Builder> sageMakerSavingsPlans) {
        SageMakerSavingsPlans.Builder builder = SageMakerSavingsPlans.builder();
        sageMakerSavingsPlans.accept(builder);
        return ResourceDetails.fromSageMakerSavingsPlans((SageMakerSavingsPlans)builder.build());
    }

    public static ResourceDetails fromRdsDbInstance(RdsDbInstance rdsDbInstance) {
        return (ResourceDetails)ResourceDetails.builder().rdsDbInstance(rdsDbInstance).build();
    }

    public static ResourceDetails fromRdsDbInstance(Consumer<RdsDbInstance.Builder> rdsDbInstance) {
        RdsDbInstance.Builder builder = RdsDbInstance.builder();
        rdsDbInstance.accept(builder);
        return ResourceDetails.fromRdsDbInstance((RdsDbInstance)builder.build());
    }

    public static ResourceDetails fromRdsDbInstanceStorage(RdsDbInstanceStorage rdsDbInstanceStorage) {
        return (ResourceDetails)ResourceDetails.builder().rdsDbInstanceStorage(rdsDbInstanceStorage).build();
    }

    public static ResourceDetails fromRdsDbInstanceStorage(Consumer<RdsDbInstanceStorage.Builder> rdsDbInstanceStorage) {
        RdsDbInstanceStorage.Builder builder = RdsDbInstanceStorage.builder();
        rdsDbInstanceStorage.accept(builder);
        return ResourceDetails.fromRdsDbInstanceStorage((RdsDbInstanceStorage)builder.build());
    }

    public static ResourceDetails fromAuroraDbClusterStorage(AuroraDbClusterStorage auroraDbClusterStorage) {
        return (ResourceDetails)ResourceDetails.builder().auroraDbClusterStorage(auroraDbClusterStorage).build();
    }

    public static ResourceDetails fromAuroraDbClusterStorage(Consumer<AuroraDbClusterStorage.Builder> auroraDbClusterStorage) {
        AuroraDbClusterStorage.Builder builder = AuroraDbClusterStorage.builder();
        auroraDbClusterStorage.accept(builder);
        return ResourceDetails.fromAuroraDbClusterStorage((AuroraDbClusterStorage)builder.build());
    }

    public static ResourceDetails fromDynamoDbReservedCapacity(DynamoDbReservedCapacity dynamoDbReservedCapacity) {
        return (ResourceDetails)ResourceDetails.builder().dynamoDbReservedCapacity(dynamoDbReservedCapacity).build();
    }

    public static ResourceDetails fromDynamoDbReservedCapacity(Consumer<DynamoDbReservedCapacity.Builder> dynamoDbReservedCapacity) {
        DynamoDbReservedCapacity.Builder builder = DynamoDbReservedCapacity.builder();
        dynamoDbReservedCapacity.accept(builder);
        return ResourceDetails.fromDynamoDbReservedCapacity((DynamoDbReservedCapacity)builder.build());
    }

    public static ResourceDetails fromMemoryDbReservedInstances(MemoryDbReservedInstances memoryDbReservedInstances) {
        return (ResourceDetails)ResourceDetails.builder().memoryDbReservedInstances(memoryDbReservedInstances).build();
    }

    public static ResourceDetails fromMemoryDbReservedInstances(Consumer<MemoryDbReservedInstances.Builder> memoryDbReservedInstances) {
        MemoryDbReservedInstances.Builder builder = MemoryDbReservedInstances.builder();
        memoryDbReservedInstances.accept(builder);
        return ResourceDetails.fromMemoryDbReservedInstances((MemoryDbReservedInstances)builder.build());
    }

    public static ResourceDetails fromNatGateway(NatGateway natGateway) {
        return (ResourceDetails)ResourceDetails.builder().natGateway(natGateway).build();
    }

    public static ResourceDetails fromNatGateway(Consumer<NatGateway.Builder> natGateway) {
        NatGateway.Builder builder = NatGateway.builder();
        natGateway.accept(builder);
        return ResourceDetails.fromNatGateway((NatGateway)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lambdaFunction", LAMBDA_FUNCTION_FIELD);
        map.put("ecsService", ECS_SERVICE_FIELD);
        map.put("ec2Instance", EC2_INSTANCE_FIELD);
        map.put("ebsVolume", EBS_VOLUME_FIELD);
        map.put("ec2AutoScalingGroup", EC2_AUTO_SCALING_GROUP_FIELD);
        map.put("ec2ReservedInstances", EC2_RESERVED_INSTANCES_FIELD);
        map.put("rdsReservedInstances", RDS_RESERVED_INSTANCES_FIELD);
        map.put("elastiCacheReservedInstances", ELASTI_CACHE_RESERVED_INSTANCES_FIELD);
        map.put("openSearchReservedInstances", OPEN_SEARCH_RESERVED_INSTANCES_FIELD);
        map.put("redshiftReservedInstances", REDSHIFT_RESERVED_INSTANCES_FIELD);
        map.put("ec2InstanceSavingsPlans", EC2_INSTANCE_SAVINGS_PLANS_FIELD);
        map.put("computeSavingsPlans", COMPUTE_SAVINGS_PLANS_FIELD);
        map.put("sageMakerSavingsPlans", SAGE_MAKER_SAVINGS_PLANS_FIELD);
        map.put("rdsDbInstance", RDS_DB_INSTANCE_FIELD);
        map.put("rdsDbInstanceStorage", RDS_DB_INSTANCE_STORAGE_FIELD);
        map.put("auroraDbClusterStorage", AURORA_DB_CLUSTER_STORAGE_FIELD);
        map.put("dynamoDbReservedCapacity", DYNAMO_DB_RESERVED_CAPACITY_FIELD);
        map.put("memoryDbReservedInstances", MEMORY_DB_RESERVED_INSTANCES_FIELD);
        map.put("natGateway", NAT_GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LAMBDA_FUNCTION,
        ECS_SERVICE,
        EC2_INSTANCE,
        EBS_VOLUME,
        EC2_AUTO_SCALING_GROUP,
        EC2_RESERVED_INSTANCES,
        RDS_RESERVED_INSTANCES,
        ELASTI_CACHE_RESERVED_INSTANCES,
        OPEN_SEARCH_RESERVED_INSTANCES,
        REDSHIFT_RESERVED_INSTANCES,
        EC2_INSTANCE_SAVINGS_PLANS,
        COMPUTE_SAVINGS_PLANS,
        SAGE_MAKER_SAVINGS_PLANS,
        RDS_DB_INSTANCE,
        RDS_DB_INSTANCE_STORAGE,
        AURORA_DB_CLUSTER_STORAGE,
        DYNAMO_DB_RESERVED_CAPACITY,
        MEMORY_DB_RESERVED_INSTANCES,
        NAT_GATEWAY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private LambdaFunction lambdaFunction;
        private EcsService ecsService;
        private Ec2Instance ec2Instance;
        private EbsVolume ebsVolume;
        private Ec2AutoScalingGroup ec2AutoScalingGroup;
        private Ec2ReservedInstances ec2ReservedInstances;
        private RdsReservedInstances rdsReservedInstances;
        private ElastiCacheReservedInstances elastiCacheReservedInstances;
        private OpenSearchReservedInstances openSearchReservedInstances;
        private RedshiftReservedInstances redshiftReservedInstances;
        private Ec2InstanceSavingsPlans ec2InstanceSavingsPlans;
        private ComputeSavingsPlans computeSavingsPlans;
        private SageMakerSavingsPlans sageMakerSavingsPlans;
        private RdsDbInstance rdsDbInstance;
        private RdsDbInstanceStorage rdsDbInstanceStorage;
        private AuroraDbClusterStorage auroraDbClusterStorage;
        private DynamoDbReservedCapacity dynamoDbReservedCapacity;
        private MemoryDbReservedInstances memoryDbReservedInstances;
        private NatGateway natGateway;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            this.lambdaFunction(model.lambdaFunction);
            this.ecsService(model.ecsService);
            this.ec2Instance(model.ec2Instance);
            this.ebsVolume(model.ebsVolume);
            this.ec2AutoScalingGroup(model.ec2AutoScalingGroup);
            this.ec2ReservedInstances(model.ec2ReservedInstances);
            this.rdsReservedInstances(model.rdsReservedInstances);
            this.elastiCacheReservedInstances(model.elastiCacheReservedInstances);
            this.openSearchReservedInstances(model.openSearchReservedInstances);
            this.redshiftReservedInstances(model.redshiftReservedInstances);
            this.ec2InstanceSavingsPlans(model.ec2InstanceSavingsPlans);
            this.computeSavingsPlans(model.computeSavingsPlans);
            this.sageMakerSavingsPlans(model.sageMakerSavingsPlans);
            this.rdsDbInstance(model.rdsDbInstance);
            this.rdsDbInstanceStorage(model.rdsDbInstanceStorage);
            this.auroraDbClusterStorage(model.auroraDbClusterStorage);
            this.dynamoDbReservedCapacity(model.dynamoDbReservedCapacity);
            this.memoryDbReservedInstances(model.memoryDbReservedInstances);
            this.natGateway(model.natGateway);
        }

        public final LambdaFunction.Builder getLambdaFunction() {
            return this.lambdaFunction != null ? this.lambdaFunction.toBuilder() : null;
        }

        public final void setLambdaFunction(LambdaFunction.BuilderImpl lambdaFunction) {
            LambdaFunction oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
        }

        @Override
        public final Builder lambdaFunction(LambdaFunction lambdaFunction) {
            LambdaFunction oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
            return this;
        }

        public final EcsService.Builder getEcsService() {
            return this.ecsService != null ? this.ecsService.toBuilder() : null;
        }

        public final void setEcsService(EcsService.BuilderImpl ecsService) {
            EcsService oldValue = this.ecsService;
            this.ecsService = ecsService != null ? ecsService.build() : null;
            this.handleUnionValueChange(Type.ECS_SERVICE, oldValue, this.ecsService);
        }

        @Override
        public final Builder ecsService(EcsService ecsService) {
            EcsService oldValue = this.ecsService;
            this.ecsService = ecsService;
            this.handleUnionValueChange(Type.ECS_SERVICE, oldValue, this.ecsService);
            return this;
        }

        public final Ec2Instance.Builder getEc2Instance() {
            return this.ec2Instance != null ? this.ec2Instance.toBuilder() : null;
        }

        public final void setEc2Instance(Ec2Instance.BuilderImpl ec2Instance) {
            Ec2Instance oldValue = this.ec2Instance;
            this.ec2Instance = ec2Instance != null ? ec2Instance.build() : null;
            this.handleUnionValueChange(Type.EC2_INSTANCE, oldValue, this.ec2Instance);
        }

        @Override
        public final Builder ec2Instance(Ec2Instance ec2Instance) {
            Ec2Instance oldValue = this.ec2Instance;
            this.ec2Instance = ec2Instance;
            this.handleUnionValueChange(Type.EC2_INSTANCE, oldValue, this.ec2Instance);
            return this;
        }

        public final EbsVolume.Builder getEbsVolume() {
            return this.ebsVolume != null ? this.ebsVolume.toBuilder() : null;
        }

        public final void setEbsVolume(EbsVolume.BuilderImpl ebsVolume) {
            EbsVolume oldValue = this.ebsVolume;
            this.ebsVolume = ebsVolume != null ? ebsVolume.build() : null;
            this.handleUnionValueChange(Type.EBS_VOLUME, oldValue, this.ebsVolume);
        }

        @Override
        public final Builder ebsVolume(EbsVolume ebsVolume) {
            EbsVolume oldValue = this.ebsVolume;
            this.ebsVolume = ebsVolume;
            this.handleUnionValueChange(Type.EBS_VOLUME, oldValue, this.ebsVolume);
            return this;
        }

        public final Ec2AutoScalingGroup.Builder getEc2AutoScalingGroup() {
            return this.ec2AutoScalingGroup != null ? this.ec2AutoScalingGroup.toBuilder() : null;
        }

        public final void setEc2AutoScalingGroup(Ec2AutoScalingGroup.BuilderImpl ec2AutoScalingGroup) {
            Ec2AutoScalingGroup oldValue = this.ec2AutoScalingGroup;
            this.ec2AutoScalingGroup = ec2AutoScalingGroup != null ? ec2AutoScalingGroup.build() : null;
            this.handleUnionValueChange(Type.EC2_AUTO_SCALING_GROUP, oldValue, this.ec2AutoScalingGroup);
        }

        @Override
        public final Builder ec2AutoScalingGroup(Ec2AutoScalingGroup ec2AutoScalingGroup) {
            Ec2AutoScalingGroup oldValue = this.ec2AutoScalingGroup;
            this.ec2AutoScalingGroup = ec2AutoScalingGroup;
            this.handleUnionValueChange(Type.EC2_AUTO_SCALING_GROUP, oldValue, this.ec2AutoScalingGroup);
            return this;
        }

        public final Ec2ReservedInstances.Builder getEc2ReservedInstances() {
            return this.ec2ReservedInstances != null ? this.ec2ReservedInstances.toBuilder() : null;
        }

        public final void setEc2ReservedInstances(Ec2ReservedInstances.BuilderImpl ec2ReservedInstances) {
            Ec2ReservedInstances oldValue = this.ec2ReservedInstances;
            this.ec2ReservedInstances = ec2ReservedInstances != null ? ec2ReservedInstances.build() : null;
            this.handleUnionValueChange(Type.EC2_RESERVED_INSTANCES, oldValue, this.ec2ReservedInstances);
        }

        @Override
        public final Builder ec2ReservedInstances(Ec2ReservedInstances ec2ReservedInstances) {
            Ec2ReservedInstances oldValue = this.ec2ReservedInstances;
            this.ec2ReservedInstances = ec2ReservedInstances;
            this.handleUnionValueChange(Type.EC2_RESERVED_INSTANCES, oldValue, this.ec2ReservedInstances);
            return this;
        }

        public final RdsReservedInstances.Builder getRdsReservedInstances() {
            return this.rdsReservedInstances != null ? this.rdsReservedInstances.toBuilder() : null;
        }

        public final void setRdsReservedInstances(RdsReservedInstances.BuilderImpl rdsReservedInstances) {
            RdsReservedInstances oldValue = this.rdsReservedInstances;
            this.rdsReservedInstances = rdsReservedInstances != null ? rdsReservedInstances.build() : null;
            this.handleUnionValueChange(Type.RDS_RESERVED_INSTANCES, oldValue, this.rdsReservedInstances);
        }

        @Override
        public final Builder rdsReservedInstances(RdsReservedInstances rdsReservedInstances) {
            RdsReservedInstances oldValue = this.rdsReservedInstances;
            this.rdsReservedInstances = rdsReservedInstances;
            this.handleUnionValueChange(Type.RDS_RESERVED_INSTANCES, oldValue, this.rdsReservedInstances);
            return this;
        }

        public final ElastiCacheReservedInstances.Builder getElastiCacheReservedInstances() {
            return this.elastiCacheReservedInstances != null ? this.elastiCacheReservedInstances.toBuilder() : null;
        }

        public final void setElastiCacheReservedInstances(ElastiCacheReservedInstances.BuilderImpl elastiCacheReservedInstances) {
            ElastiCacheReservedInstances oldValue = this.elastiCacheReservedInstances;
            this.elastiCacheReservedInstances = elastiCacheReservedInstances != null ? elastiCacheReservedInstances.build() : null;
            this.handleUnionValueChange(Type.ELASTI_CACHE_RESERVED_INSTANCES, oldValue, this.elastiCacheReservedInstances);
        }

        @Override
        public final Builder elastiCacheReservedInstances(ElastiCacheReservedInstances elastiCacheReservedInstances) {
            ElastiCacheReservedInstances oldValue = this.elastiCacheReservedInstances;
            this.elastiCacheReservedInstances = elastiCacheReservedInstances;
            this.handleUnionValueChange(Type.ELASTI_CACHE_RESERVED_INSTANCES, oldValue, this.elastiCacheReservedInstances);
            return this;
        }

        public final OpenSearchReservedInstances.Builder getOpenSearchReservedInstances() {
            return this.openSearchReservedInstances != null ? this.openSearchReservedInstances.toBuilder() : null;
        }

        public final void setOpenSearchReservedInstances(OpenSearchReservedInstances.BuilderImpl openSearchReservedInstances) {
            OpenSearchReservedInstances oldValue = this.openSearchReservedInstances;
            this.openSearchReservedInstances = openSearchReservedInstances != null ? openSearchReservedInstances.build() : null;
            this.handleUnionValueChange(Type.OPEN_SEARCH_RESERVED_INSTANCES, oldValue, this.openSearchReservedInstances);
        }

        @Override
        public final Builder openSearchReservedInstances(OpenSearchReservedInstances openSearchReservedInstances) {
            OpenSearchReservedInstances oldValue = this.openSearchReservedInstances;
            this.openSearchReservedInstances = openSearchReservedInstances;
            this.handleUnionValueChange(Type.OPEN_SEARCH_RESERVED_INSTANCES, oldValue, this.openSearchReservedInstances);
            return this;
        }

        public final RedshiftReservedInstances.Builder getRedshiftReservedInstances() {
            return this.redshiftReservedInstances != null ? this.redshiftReservedInstances.toBuilder() : null;
        }

        public final void setRedshiftReservedInstances(RedshiftReservedInstances.BuilderImpl redshiftReservedInstances) {
            RedshiftReservedInstances oldValue = this.redshiftReservedInstances;
            this.redshiftReservedInstances = redshiftReservedInstances != null ? redshiftReservedInstances.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_RESERVED_INSTANCES, oldValue, this.redshiftReservedInstances);
        }

        @Override
        public final Builder redshiftReservedInstances(RedshiftReservedInstances redshiftReservedInstances) {
            RedshiftReservedInstances oldValue = this.redshiftReservedInstances;
            this.redshiftReservedInstances = redshiftReservedInstances;
            this.handleUnionValueChange(Type.REDSHIFT_RESERVED_INSTANCES, oldValue, this.redshiftReservedInstances);
            return this;
        }

        public final Ec2InstanceSavingsPlans.Builder getEc2InstanceSavingsPlans() {
            return this.ec2InstanceSavingsPlans != null ? this.ec2InstanceSavingsPlans.toBuilder() : null;
        }

        public final void setEc2InstanceSavingsPlans(Ec2InstanceSavingsPlans.BuilderImpl ec2InstanceSavingsPlans) {
            Ec2InstanceSavingsPlans oldValue = this.ec2InstanceSavingsPlans;
            this.ec2InstanceSavingsPlans = ec2InstanceSavingsPlans != null ? ec2InstanceSavingsPlans.build() : null;
            this.handleUnionValueChange(Type.EC2_INSTANCE_SAVINGS_PLANS, oldValue, this.ec2InstanceSavingsPlans);
        }

        @Override
        public final Builder ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans ec2InstanceSavingsPlans) {
            Ec2InstanceSavingsPlans oldValue = this.ec2InstanceSavingsPlans;
            this.ec2InstanceSavingsPlans = ec2InstanceSavingsPlans;
            this.handleUnionValueChange(Type.EC2_INSTANCE_SAVINGS_PLANS, oldValue, this.ec2InstanceSavingsPlans);
            return this;
        }

        public final ComputeSavingsPlans.Builder getComputeSavingsPlans() {
            return this.computeSavingsPlans != null ? this.computeSavingsPlans.toBuilder() : null;
        }

        public final void setComputeSavingsPlans(ComputeSavingsPlans.BuilderImpl computeSavingsPlans) {
            ComputeSavingsPlans oldValue = this.computeSavingsPlans;
            this.computeSavingsPlans = computeSavingsPlans != null ? computeSavingsPlans.build() : null;
            this.handleUnionValueChange(Type.COMPUTE_SAVINGS_PLANS, oldValue, this.computeSavingsPlans);
        }

        @Override
        public final Builder computeSavingsPlans(ComputeSavingsPlans computeSavingsPlans) {
            ComputeSavingsPlans oldValue = this.computeSavingsPlans;
            this.computeSavingsPlans = computeSavingsPlans;
            this.handleUnionValueChange(Type.COMPUTE_SAVINGS_PLANS, oldValue, this.computeSavingsPlans);
            return this;
        }

        public final SageMakerSavingsPlans.Builder getSageMakerSavingsPlans() {
            return this.sageMakerSavingsPlans != null ? this.sageMakerSavingsPlans.toBuilder() : null;
        }

        public final void setSageMakerSavingsPlans(SageMakerSavingsPlans.BuilderImpl sageMakerSavingsPlans) {
            SageMakerSavingsPlans oldValue = this.sageMakerSavingsPlans;
            this.sageMakerSavingsPlans = sageMakerSavingsPlans != null ? sageMakerSavingsPlans.build() : null;
            this.handleUnionValueChange(Type.SAGE_MAKER_SAVINGS_PLANS, oldValue, this.sageMakerSavingsPlans);
        }

        @Override
        public final Builder sageMakerSavingsPlans(SageMakerSavingsPlans sageMakerSavingsPlans) {
            SageMakerSavingsPlans oldValue = this.sageMakerSavingsPlans;
            this.sageMakerSavingsPlans = sageMakerSavingsPlans;
            this.handleUnionValueChange(Type.SAGE_MAKER_SAVINGS_PLANS, oldValue, this.sageMakerSavingsPlans);
            return this;
        }

        public final RdsDbInstance.Builder getRdsDbInstance() {
            return this.rdsDbInstance != null ? this.rdsDbInstance.toBuilder() : null;
        }

        public final void setRdsDbInstance(RdsDbInstance.BuilderImpl rdsDbInstance) {
            RdsDbInstance oldValue = this.rdsDbInstance;
            this.rdsDbInstance = rdsDbInstance != null ? rdsDbInstance.build() : null;
            this.handleUnionValueChange(Type.RDS_DB_INSTANCE, oldValue, this.rdsDbInstance);
        }

        @Override
        public final Builder rdsDbInstance(RdsDbInstance rdsDbInstance) {
            RdsDbInstance oldValue = this.rdsDbInstance;
            this.rdsDbInstance = rdsDbInstance;
            this.handleUnionValueChange(Type.RDS_DB_INSTANCE, oldValue, this.rdsDbInstance);
            return this;
        }

        public final RdsDbInstanceStorage.Builder getRdsDbInstanceStorage() {
            return this.rdsDbInstanceStorage != null ? this.rdsDbInstanceStorage.toBuilder() : null;
        }

        public final void setRdsDbInstanceStorage(RdsDbInstanceStorage.BuilderImpl rdsDbInstanceStorage) {
            RdsDbInstanceStorage oldValue = this.rdsDbInstanceStorage;
            this.rdsDbInstanceStorage = rdsDbInstanceStorage != null ? rdsDbInstanceStorage.build() : null;
            this.handleUnionValueChange(Type.RDS_DB_INSTANCE_STORAGE, oldValue, this.rdsDbInstanceStorage);
        }

        @Override
        public final Builder rdsDbInstanceStorage(RdsDbInstanceStorage rdsDbInstanceStorage) {
            RdsDbInstanceStorage oldValue = this.rdsDbInstanceStorage;
            this.rdsDbInstanceStorage = rdsDbInstanceStorage;
            this.handleUnionValueChange(Type.RDS_DB_INSTANCE_STORAGE, oldValue, this.rdsDbInstanceStorage);
            return this;
        }

        public final AuroraDbClusterStorage.Builder getAuroraDbClusterStorage() {
            return this.auroraDbClusterStorage != null ? this.auroraDbClusterStorage.toBuilder() : null;
        }

        public final void setAuroraDbClusterStorage(AuroraDbClusterStorage.BuilderImpl auroraDbClusterStorage) {
            AuroraDbClusterStorage oldValue = this.auroraDbClusterStorage;
            this.auroraDbClusterStorage = auroraDbClusterStorage != null ? auroraDbClusterStorage.build() : null;
            this.handleUnionValueChange(Type.AURORA_DB_CLUSTER_STORAGE, oldValue, this.auroraDbClusterStorage);
        }

        @Override
        public final Builder auroraDbClusterStorage(AuroraDbClusterStorage auroraDbClusterStorage) {
            AuroraDbClusterStorage oldValue = this.auroraDbClusterStorage;
            this.auroraDbClusterStorage = auroraDbClusterStorage;
            this.handleUnionValueChange(Type.AURORA_DB_CLUSTER_STORAGE, oldValue, this.auroraDbClusterStorage);
            return this;
        }

        public final DynamoDbReservedCapacity.Builder getDynamoDbReservedCapacity() {
            return this.dynamoDbReservedCapacity != null ? this.dynamoDbReservedCapacity.toBuilder() : null;
        }

        public final void setDynamoDbReservedCapacity(DynamoDbReservedCapacity.BuilderImpl dynamoDbReservedCapacity) {
            DynamoDbReservedCapacity oldValue = this.dynamoDbReservedCapacity;
            this.dynamoDbReservedCapacity = dynamoDbReservedCapacity != null ? dynamoDbReservedCapacity.build() : null;
            this.handleUnionValueChange(Type.DYNAMO_DB_RESERVED_CAPACITY, oldValue, this.dynamoDbReservedCapacity);
        }

        @Override
        public final Builder dynamoDbReservedCapacity(DynamoDbReservedCapacity dynamoDbReservedCapacity) {
            DynamoDbReservedCapacity oldValue = this.dynamoDbReservedCapacity;
            this.dynamoDbReservedCapacity = dynamoDbReservedCapacity;
            this.handleUnionValueChange(Type.DYNAMO_DB_RESERVED_CAPACITY, oldValue, this.dynamoDbReservedCapacity);
            return this;
        }

        public final MemoryDbReservedInstances.Builder getMemoryDbReservedInstances() {
            return this.memoryDbReservedInstances != null ? this.memoryDbReservedInstances.toBuilder() : null;
        }

        public final void setMemoryDbReservedInstances(MemoryDbReservedInstances.BuilderImpl memoryDbReservedInstances) {
            MemoryDbReservedInstances oldValue = this.memoryDbReservedInstances;
            this.memoryDbReservedInstances = memoryDbReservedInstances != null ? memoryDbReservedInstances.build() : null;
            this.handleUnionValueChange(Type.MEMORY_DB_RESERVED_INSTANCES, oldValue, this.memoryDbReservedInstances);
        }

        @Override
        public final Builder memoryDbReservedInstances(MemoryDbReservedInstances memoryDbReservedInstances) {
            MemoryDbReservedInstances oldValue = this.memoryDbReservedInstances;
            this.memoryDbReservedInstances = memoryDbReservedInstances;
            this.handleUnionValueChange(Type.MEMORY_DB_RESERVED_INSTANCES, oldValue, this.memoryDbReservedInstances);
            return this;
        }

        public final NatGateway.Builder getNatGateway() {
            return this.natGateway != null ? this.natGateway.toBuilder() : null;
        }

        public final void setNatGateway(NatGateway.BuilderImpl natGateway) {
            NatGateway oldValue = this.natGateway;
            this.natGateway = natGateway != null ? natGateway.build() : null;
            this.handleUnionValueChange(Type.NAT_GATEWAY, oldValue, this.natGateway);
        }

        @Override
        public final Builder natGateway(NatGateway natGateway) {
            NatGateway oldValue = this.natGateway;
            this.natGateway = natGateway;
            this.handleUnionValueChange(Type.NAT_GATEWAY, oldValue, this.natGateway);
            return this;
        }

        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetails> {
        public Builder lambdaFunction(LambdaFunction var1);

        default public Builder lambdaFunction(Consumer<LambdaFunction.Builder> lambdaFunction) {
            return this.lambdaFunction((LambdaFunction)((LambdaFunction.Builder)LambdaFunction.builder().applyMutation(lambdaFunction)).build());
        }

        public Builder ecsService(EcsService var1);

        default public Builder ecsService(Consumer<EcsService.Builder> ecsService) {
            return this.ecsService((EcsService)((EcsService.Builder)EcsService.builder().applyMutation(ecsService)).build());
        }

        public Builder ec2Instance(Ec2Instance var1);

        default public Builder ec2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
            return this.ec2Instance((Ec2Instance)((Ec2Instance.Builder)Ec2Instance.builder().applyMutation(ec2Instance)).build());
        }

        public Builder ebsVolume(EbsVolume var1);

        default public Builder ebsVolume(Consumer<EbsVolume.Builder> ebsVolume) {
            return this.ebsVolume((EbsVolume)((EbsVolume.Builder)EbsVolume.builder().applyMutation(ebsVolume)).build());
        }

        public Builder ec2AutoScalingGroup(Ec2AutoScalingGroup var1);

        default public Builder ec2AutoScalingGroup(Consumer<Ec2AutoScalingGroup.Builder> ec2AutoScalingGroup) {
            return this.ec2AutoScalingGroup((Ec2AutoScalingGroup)((Ec2AutoScalingGroup.Builder)Ec2AutoScalingGroup.builder().applyMutation(ec2AutoScalingGroup)).build());
        }

        public Builder ec2ReservedInstances(Ec2ReservedInstances var1);

        default public Builder ec2ReservedInstances(Consumer<Ec2ReservedInstances.Builder> ec2ReservedInstances) {
            return this.ec2ReservedInstances((Ec2ReservedInstances)((Ec2ReservedInstances.Builder)Ec2ReservedInstances.builder().applyMutation(ec2ReservedInstances)).build());
        }

        public Builder rdsReservedInstances(RdsReservedInstances var1);

        default public Builder rdsReservedInstances(Consumer<RdsReservedInstances.Builder> rdsReservedInstances) {
            return this.rdsReservedInstances((RdsReservedInstances)((RdsReservedInstances.Builder)RdsReservedInstances.builder().applyMutation(rdsReservedInstances)).build());
        }

        public Builder elastiCacheReservedInstances(ElastiCacheReservedInstances var1);

        default public Builder elastiCacheReservedInstances(Consumer<ElastiCacheReservedInstances.Builder> elastiCacheReservedInstances) {
            return this.elastiCacheReservedInstances((ElastiCacheReservedInstances)((ElastiCacheReservedInstances.Builder)ElastiCacheReservedInstances.builder().applyMutation(elastiCacheReservedInstances)).build());
        }

        public Builder openSearchReservedInstances(OpenSearchReservedInstances var1);

        default public Builder openSearchReservedInstances(Consumer<OpenSearchReservedInstances.Builder> openSearchReservedInstances) {
            return this.openSearchReservedInstances((OpenSearchReservedInstances)((OpenSearchReservedInstances.Builder)OpenSearchReservedInstances.builder().applyMutation(openSearchReservedInstances)).build());
        }

        public Builder redshiftReservedInstances(RedshiftReservedInstances var1);

        default public Builder redshiftReservedInstances(Consumer<RedshiftReservedInstances.Builder> redshiftReservedInstances) {
            return this.redshiftReservedInstances((RedshiftReservedInstances)((RedshiftReservedInstances.Builder)RedshiftReservedInstances.builder().applyMutation(redshiftReservedInstances)).build());
        }

        public Builder ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans var1);

        default public Builder ec2InstanceSavingsPlans(Consumer<Ec2InstanceSavingsPlans.Builder> ec2InstanceSavingsPlans) {
            return this.ec2InstanceSavingsPlans((Ec2InstanceSavingsPlans)((Ec2InstanceSavingsPlans.Builder)Ec2InstanceSavingsPlans.builder().applyMutation(ec2InstanceSavingsPlans)).build());
        }

        public Builder computeSavingsPlans(ComputeSavingsPlans var1);

        default public Builder computeSavingsPlans(Consumer<ComputeSavingsPlans.Builder> computeSavingsPlans) {
            return this.computeSavingsPlans((ComputeSavingsPlans)((ComputeSavingsPlans.Builder)ComputeSavingsPlans.builder().applyMutation(computeSavingsPlans)).build());
        }

        public Builder sageMakerSavingsPlans(SageMakerSavingsPlans var1);

        default public Builder sageMakerSavingsPlans(Consumer<SageMakerSavingsPlans.Builder> sageMakerSavingsPlans) {
            return this.sageMakerSavingsPlans((SageMakerSavingsPlans)((SageMakerSavingsPlans.Builder)SageMakerSavingsPlans.builder().applyMutation(sageMakerSavingsPlans)).build());
        }

        public Builder rdsDbInstance(RdsDbInstance var1);

        default public Builder rdsDbInstance(Consumer<RdsDbInstance.Builder> rdsDbInstance) {
            return this.rdsDbInstance((RdsDbInstance)((RdsDbInstance.Builder)RdsDbInstance.builder().applyMutation(rdsDbInstance)).build());
        }

        public Builder rdsDbInstanceStorage(RdsDbInstanceStorage var1);

        default public Builder rdsDbInstanceStorage(Consumer<RdsDbInstanceStorage.Builder> rdsDbInstanceStorage) {
            return this.rdsDbInstanceStorage((RdsDbInstanceStorage)((RdsDbInstanceStorage.Builder)RdsDbInstanceStorage.builder().applyMutation(rdsDbInstanceStorage)).build());
        }

        public Builder auroraDbClusterStorage(AuroraDbClusterStorage var1);

        default public Builder auroraDbClusterStorage(Consumer<AuroraDbClusterStorage.Builder> auroraDbClusterStorage) {
            return this.auroraDbClusterStorage((AuroraDbClusterStorage)((AuroraDbClusterStorage.Builder)AuroraDbClusterStorage.builder().applyMutation(auroraDbClusterStorage)).build());
        }

        public Builder dynamoDbReservedCapacity(DynamoDbReservedCapacity var1);

        default public Builder dynamoDbReservedCapacity(Consumer<DynamoDbReservedCapacity.Builder> dynamoDbReservedCapacity) {
            return this.dynamoDbReservedCapacity((DynamoDbReservedCapacity)((DynamoDbReservedCapacity.Builder)DynamoDbReservedCapacity.builder().applyMutation(dynamoDbReservedCapacity)).build());
        }

        public Builder memoryDbReservedInstances(MemoryDbReservedInstances var1);

        default public Builder memoryDbReservedInstances(Consumer<MemoryDbReservedInstances.Builder> memoryDbReservedInstances) {
            return this.memoryDbReservedInstances((MemoryDbReservedInstances)((MemoryDbReservedInstances.Builder)MemoryDbReservedInstances.builder().applyMutation(memoryDbReservedInstances)).build());
        }

        public Builder natGateway(NatGateway var1);

        default public Builder natGateway(Consumer<NatGateway.Builder> natGateway) {
            return this.natGateway((NatGateway)((NatGateway.Builder)NatGateway.builder().applyMutation(natGateway)).build());
        }
    }
}

