/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGatewayConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NatGatewayConfiguration> {
    private static final SdkField<Long> ACTIVE_CONNECTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeConnectionCount").getter(NatGatewayConfiguration.getter(NatGatewayConfiguration::activeConnectionCount)).setter(NatGatewayConfiguration.setter(Builder::activeConnectionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeConnectionCount").build()}).build();
    private static final SdkField<Long> PACKETS_IN_FROM_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("packetsInFromSource").getter(NatGatewayConfiguration.getter(NatGatewayConfiguration::packetsInFromSource)).setter(NatGatewayConfiguration.setter(Builder::packetsInFromSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetsInFromSource").build()}).build();
    private static final SdkField<Long> PACKETS_IN_FROM_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("packetsInFromDestination").getter(NatGatewayConfiguration.getter(NatGatewayConfiguration::packetsInFromDestination)).setter(NatGatewayConfiguration.setter(Builder::packetsInFromDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetsInFromDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_CONNECTION_COUNT_FIELD, PACKETS_IN_FROM_SOURCE_FIELD, PACKETS_IN_FROM_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NatGatewayConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long activeConnectionCount;
    private final Long packetsInFromSource;
    private final Long packetsInFromDestination;

    private NatGatewayConfiguration(BuilderImpl builder) {
        this.activeConnectionCount = builder.activeConnectionCount;
        this.packetsInFromSource = builder.packetsInFromSource;
        this.packetsInFromDestination = builder.packetsInFromDestination;
    }

    public final Long activeConnectionCount() {
        return this.activeConnectionCount;
    }

    public final Long packetsInFromSource() {
        return this.packetsInFromSource;
    }

    public final Long packetsInFromDestination() {
        return this.packetsInFromDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeConnectionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetsInFromSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetsInFromDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayConfiguration)) {
            return false;
        }
        NatGatewayConfiguration other = (NatGatewayConfiguration)obj;
        return Objects.equals(this.activeConnectionCount(), other.activeConnectionCount()) && Objects.equals(this.packetsInFromSource(), other.packetsInFromSource()) && Objects.equals(this.packetsInFromDestination(), other.packetsInFromDestination());
    }

    public final String toString() {
        return ToString.builder((String)"NatGatewayConfiguration").add("ActiveConnectionCount", (Object)this.activeConnectionCount()).add("PacketsInFromSource", (Object)this.packetsInFromSource()).add("PacketsInFromDestination", (Object)this.packetsInFromDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeConnectionCount": {
                return Optional.ofNullable(clazz.cast(this.activeConnectionCount()));
            }
            case "packetsInFromSource": {
                return Optional.ofNullable(clazz.cast(this.packetsInFromSource()));
            }
            case "packetsInFromDestination": {
                return Optional.ofNullable(clazz.cast(this.packetsInFromDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("activeConnectionCount", ACTIVE_CONNECTION_COUNT_FIELD);
        map.put("packetsInFromSource", PACKETS_IN_FROM_SOURCE_FIELD);
        map.put("packetsInFromDestination", PACKETS_IN_FROM_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayConfiguration, T> g) {
        return obj -> g.apply((NatGatewayConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long activeConnectionCount;
        private Long packetsInFromSource;
        private Long packetsInFromDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayConfiguration model) {
            this.activeConnectionCount(model.activeConnectionCount);
            this.packetsInFromSource(model.packetsInFromSource);
            this.packetsInFromDestination(model.packetsInFromDestination);
        }

        public final Long getActiveConnectionCount() {
            return this.activeConnectionCount;
        }

        public final void setActiveConnectionCount(Long activeConnectionCount) {
            this.activeConnectionCount = activeConnectionCount;
        }

        @Override
        public final Builder activeConnectionCount(Long activeConnectionCount) {
            this.activeConnectionCount = activeConnectionCount;
            return this;
        }

        public final Long getPacketsInFromSource() {
            return this.packetsInFromSource;
        }

        public final void setPacketsInFromSource(Long packetsInFromSource) {
            this.packetsInFromSource = packetsInFromSource;
        }

        @Override
        public final Builder packetsInFromSource(Long packetsInFromSource) {
            this.packetsInFromSource = packetsInFromSource;
            return this;
        }

        public final Long getPacketsInFromDestination() {
            return this.packetsInFromDestination;
        }

        public final void setPacketsInFromDestination(Long packetsInFromDestination) {
            this.packetsInFromDestination = packetsInFromDestination;
        }

        @Override
        public final Builder packetsInFromDestination(Long packetsInFromDestination) {
            this.packetsInFromDestination = packetsInFromDestination;
            return this;
        }

        public NatGatewayConfiguration build() {
            return new NatGatewayConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NatGatewayConfiguration> {
        public Builder activeConnectionCount(Long var1);

        public Builder packetsInFromSource(Long var1);

        public Builder packetsInFromDestination(Long var1);
    }
}

