/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubClientBuilder;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubServiceClientConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.DefaultCostOptimizationHubClientBuilder;
import software.amazon.awssdk.services.costoptimizationhub.model.AccessDeniedException;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubException;
import software.amazon.awssdk.services.costoptimizationhub.model.GetPreferencesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.GetPreferencesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.GetRecommendationRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.GetRecommendationResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.InternalServerException;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costoptimizationhub.model.ThrottlingException;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdateEnrollmentStatusRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdateEnrollmentStatusResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ValidationException;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesIterable;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesIterable;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsIterable;

@SdkPublicApi
@ThreadSafe
public interface CostOptimizationHubClient
extends AwsClient {
    public static final String SERVICE_NAME = "cost-optimization-hub";
    public static final String SERVICE_METADATA_ID = "cost-optimization-hub";

    default public GetPreferencesResponse getPreferences(GetPreferencesRequest getPreferencesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public GetPreferencesResponse getPreferences(Consumer<GetPreferencesRequest.Builder> getPreferencesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.getPreferences((GetPreferencesRequest)((Object)((GetPreferencesRequest.Builder)GetPreferencesRequest.builder().applyMutation(getPreferencesRequest)).build()));
    }

    default public GetRecommendationResponse getRecommendation(GetRecommendationRequest getRecommendationRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public GetRecommendationResponse getRecommendation(Consumer<GetRecommendationRequest.Builder> getRecommendationRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.getRecommendation((GetRecommendationRequest)((Object)((GetRecommendationRequest.Builder)GetRecommendationRequest.builder().applyMutation(getRecommendationRequest)).build()));
    }

    default public ListEnrollmentStatusesResponse listEnrollmentStatuses(ListEnrollmentStatusesRequest listEnrollmentStatusesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public ListEnrollmentStatusesResponse listEnrollmentStatuses(Consumer<ListEnrollmentStatusesRequest.Builder> listEnrollmentStatusesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listEnrollmentStatuses((ListEnrollmentStatusesRequest)((Object)((ListEnrollmentStatusesRequest.Builder)ListEnrollmentStatusesRequest.builder().applyMutation(listEnrollmentStatusesRequest)).build()));
    }

    default public ListEnrollmentStatusesIterable listEnrollmentStatusesPaginator(ListEnrollmentStatusesRequest listEnrollmentStatusesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return new ListEnrollmentStatusesIterable(this, listEnrollmentStatusesRequest);
    }

    default public ListEnrollmentStatusesIterable listEnrollmentStatusesPaginator(Consumer<ListEnrollmentStatusesRequest.Builder> listEnrollmentStatusesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listEnrollmentStatusesPaginator((ListEnrollmentStatusesRequest)((Object)((ListEnrollmentStatusesRequest.Builder)ListEnrollmentStatusesRequest.builder().applyMutation(listEnrollmentStatusesRequest)).build()));
    }

    default public ListRecommendationSummariesResponse listRecommendationSummaries(ListRecommendationSummariesRequest listRecommendationSummariesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public ListRecommendationSummariesResponse listRecommendationSummaries(Consumer<ListRecommendationSummariesRequest.Builder> listRecommendationSummariesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listRecommendationSummaries((ListRecommendationSummariesRequest)((Object)((ListRecommendationSummariesRequest.Builder)ListRecommendationSummariesRequest.builder().applyMutation(listRecommendationSummariesRequest)).build()));
    }

    default public ListRecommendationSummariesIterable listRecommendationSummariesPaginator(ListRecommendationSummariesRequest listRecommendationSummariesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return new ListRecommendationSummariesIterable(this, listRecommendationSummariesRequest);
    }

    default public ListRecommendationSummariesIterable listRecommendationSummariesPaginator(Consumer<ListRecommendationSummariesRequest.Builder> listRecommendationSummariesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listRecommendationSummariesPaginator((ListRecommendationSummariesRequest)((Object)((ListRecommendationSummariesRequest.Builder)ListRecommendationSummariesRequest.builder().applyMutation(listRecommendationSummariesRequest)).build()));
    }

    default public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public ListRecommendationsResponse listRecommendations(Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listRecommendations((ListRecommendationsRequest)((Object)((ListRecommendationsRequest.Builder)ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)).build()));
    }

    default public ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return new ListRecommendationsIterable(this, listRecommendationsRequest);
    }

    default public ListRecommendationsIterable listRecommendationsPaginator(Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.listRecommendationsPaginator((ListRecommendationsRequest)((Object)((ListRecommendationsRequest.Builder)ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)).build()));
    }

    default public UpdateEnrollmentStatusResponse updateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public UpdateEnrollmentStatusResponse updateEnrollmentStatus(Consumer<UpdateEnrollmentStatusRequest.Builder> updateEnrollmentStatusRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.updateEnrollmentStatus((UpdateEnrollmentStatusRequest)((Object)((UpdateEnrollmentStatusRequest.Builder)UpdateEnrollmentStatusRequest.builder().applyMutation(updateEnrollmentStatusRequest)).build()));
    }

    default public UpdatePreferencesResponse updatePreferences(UpdatePreferencesRequest updatePreferencesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        throw new UnsupportedOperationException();
    }

    default public UpdatePreferencesResponse updatePreferences(Consumer<UpdatePreferencesRequest.Builder> updatePreferencesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CostOptimizationHubException {
        return this.updatePreferences((UpdatePreferencesRequest)((Object)((UpdatePreferencesRequest.Builder)UpdatePreferencesRequest.builder().applyMutation(updatePreferencesRequest)).build()));
    }

    public static CostOptimizationHubClient create() {
        return (CostOptimizationHubClient)CostOptimizationHubClient.builder().build();
    }

    public static CostOptimizationHubClientBuilder builder() {
        return new DefaultCostOptimizationHubClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"cost-optimization-hub");
    }

    default public CostOptimizationHubServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

