/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StorageConfiguration.getter(StorageConfiguration::type)).setter(StorageConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Double> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sizeInGb").getter(StorageConfiguration.getter(StorageConfiguration::sizeInGb)).setter(StorageConfiguration.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Double sizeInGb;

    private StorageConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.sizeInGb = builder.sizeInGb;
    }

    public final String type() {
        return this.type;
    }

    public final Double sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public final String toString() {
        return ToString.builder((String)"StorageConfiguration").add("Type", (Object)this.type()).add("SizeInGb", (Object)this.sizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageConfiguration, T> g) {
        return obj -> g.apply((StorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Double sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfiguration model) {
            this.type(model.type);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Double getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Double sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Double sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public StorageConfiguration build() {
            return new StorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageConfiguration> {
        public Builder type(String var1);

        public Builder sizeInGb(Double var1);
    }
}

