/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.DimensionValues;
import software.amazon.awssdk.services.costexplorer.model.ExpressionsCopier;
import software.amazon.awssdk.services.costexplorer.model.TagValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Expression> {
    private static final SdkField<List<Expression>> OR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Expression.getter(Expression::or)).setter(Expression.setter(Builder::or)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Expression>> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Expression.getter(Expression::and)).setter(Expression.setter(Builder::and)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Expression> NOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Expression.getter(Expression::not)).setter(Expression.setter(Builder::not)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Not").build()}).build();
    private static final SdkField<DimensionValues> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Expression.getter(Expression::dimensions)).setter(Expression.setter(Builder::dimensions)).constructor(DimensionValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<TagValues> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Expression.getter(Expression::tags)).setter(Expression.setter(Builder::tags)).constructor(TagValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_FIELD, AND_FIELD, NOT_FIELD, DIMENSIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Expression> or;
    private final List<Expression> and;
    private final Expression not;
    private final DimensionValues dimensions;
    private final TagValues tags;

    private Expression(BuilderImpl builder) {
        this.or = builder.or;
        this.and = builder.and;
        this.not = builder.not;
        this.dimensions = builder.dimensions;
        this.tags = builder.tags;
    }

    public List<Expression> or() {
        return this.or;
    }

    public List<Expression> and() {
        return this.and;
    }

    public Expression not() {
        return this.not;
    }

    public DimensionValues dimensions() {
        return this.dimensions;
    }

    public TagValues tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.or());
        hashCode = 31 * hashCode + Objects.hashCode(this.and());
        hashCode = 31 * hashCode + Objects.hashCode(this.not());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.or(), other.or()) && Objects.equals(this.and(), other.and()) && Objects.equals(this.not(), other.not()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Expression").add("Or", this.or()).add("And", this.and()).add("Not", (Object)this.not()).add("Dimensions", (Object)this.dimensions()).add("Tags", (Object)this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
            case "And": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "Not": {
                return Optional.ofNullable(clazz.cast(this.not()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();
        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();
        private Expression not;
        private DimensionValues dimensions;
        private TagValues tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.or(model.or);
            this.and(model.and);
            this.not(model.not);
            this.dimensions(model.dimensions);
            this.tags(model.tags);
        }

        public final Collection<Builder> getOr() {
            return this.or != null ? (Collection)this.or.stream().map(Expression::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionsCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionsCopier.copyFromBuilder(or);
        }

        public final Collection<Builder> getAnd() {
            return this.and != null ? (Collection)this.and.stream().map(Expression::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionsCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionsCopier.copyFromBuilder(and);
        }

        public final Builder getNot() {
            return this.not != null ? this.not.toBuilder() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        public final DimensionValues.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(DimensionValues dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(DimensionValues.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final TagValues.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        @Override
        public final Builder tags(TagValues tags) {
            this.tags = tags;
            return this;
        }

        public final void setTags(TagValues.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        public Expression build() {
            return new Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Expression> {
        public Builder or(Collection<Expression> var1);

        public Builder or(Expression ... var1);

        public Builder or(Consumer<Builder> ... var1);

        public Builder and(Collection<Expression> var1);

        public Builder and(Expression ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder not(Expression var1);

        default public Builder not(Consumer<Builder> not) {
            return this.not((Expression)((Builder)Expression.builder().applyMutation(not)).build());
        }

        public Builder dimensions(DimensionValues var1);

        default public Builder dimensions(Consumer<DimensionValues.Builder> dimensions) {
            return this.dimensions((DimensionValues)((DimensionValues.Builder)DimensionValues.builder().applyMutation(dimensions)).build());
        }

        public Builder tags(TagValues var1);

        default public Builder tags(Consumer<TagValues.Builder> tags) {
            return this.tags((TagValues)((TagValues.Builder)TagValues.builder().applyMutation(tags)).build());
        }
    }
}

