/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.Anomaly;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;

public class GetAnomaliesIterable
implements SdkIterable<GetAnomaliesResponse> {
    private final CostExplorerClient client;
    private final GetAnomaliesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAnomaliesIterable(CostExplorerClient client, GetAnomaliesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAnomaliesResponseFetcher();
    }

    public Iterator<GetAnomaliesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Anomaly> anomalies() {
        Function<GetAnomaliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalies() != null) {
                return response.anomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAnomaliesResponseFetcher
    implements SyncPageFetcher<GetAnomaliesResponse> {
        private GetAnomaliesResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomaliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetAnomaliesResponse nextPage(GetAnomaliesResponse previousPage) {
            if (previousPage == null) {
                return GetAnomaliesIterable.this.client.getAnomalies(GetAnomaliesIterable.this.firstRequest);
            }
            return GetAnomaliesIterable.this.client.getAnomalies((GetAnomaliesRequest)((Object)GetAnomaliesIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

