/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTagBackfillRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryResponse;

public class ListCostAllocationTagBackfillHistoryIterable
implements SdkIterable<ListCostAllocationTagBackfillHistoryResponse> {
    private final CostExplorerClient client;
    private final ListCostAllocationTagBackfillHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCostAllocationTagBackfillHistoryIterable(CostExplorerClient client, ListCostAllocationTagBackfillHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCostAllocationTagBackfillHistoryResponseFetcher();
    }

    public Iterator<ListCostAllocationTagBackfillHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CostAllocationTagBackfillRequest> backfillRequests() {
        Function<ListCostAllocationTagBackfillHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.backfillRequests() != null) {
                return response.backfillRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCostAllocationTagBackfillHistoryResponseFetcher
    implements SyncPageFetcher<ListCostAllocationTagBackfillHistoryResponse> {
        private ListCostAllocationTagBackfillHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListCostAllocationTagBackfillHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCostAllocationTagBackfillHistoryResponse nextPage(ListCostAllocationTagBackfillHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListCostAllocationTagBackfillHistoryIterable.this.client.listCostAllocationTagBackfillHistory(ListCostAllocationTagBackfillHistoryIterable.this.firstRequest);
            }
            return ListCostAllocationTagBackfillHistoryIterable.this.client.listCostAllocationTagBackfillHistory((ListCostAllocationTagBackfillHistoryRequest)((Object)ListCostAllocationTagBackfillHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

