/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation;

public class GetRightsizingRecommendationPublisher
implements SdkPublisher<GetRightsizingRecommendationResponse> {
    private final CostExplorerAsyncClient client;
    private final GetRightsizingRecommendationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetRightsizingRecommendationPublisher(CostExplorerAsyncClient client, GetRightsizingRecommendationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetRightsizingRecommendationPublisher(CostExplorerAsyncClient client, GetRightsizingRecommendationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetRightsizingRecommendationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetRightsizingRecommendationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RightsizingRecommendation> rightsizingRecommendations() {
        Function<GetRightsizingRecommendationResponse, Iterator> getIterator = response -> {
            if (response != null && response.rightsizingRecommendations() != null) {
                return response.rightsizingRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetRightsizingRecommendationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetRightsizingRecommendationResponseFetcher
    implements AsyncPageFetcher<GetRightsizingRecommendationResponse> {
        private GetRightsizingRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetRightsizingRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetRightsizingRecommendationResponse> nextPage(GetRightsizingRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetRightsizingRecommendationPublisher.this.client.getRightsizingRecommendation(GetRightsizingRecommendationPublisher.this.firstRequest);
            }
            return GetRightsizingRecommendationPublisher.this.client.getRightsizingRecommendation((GetRightsizingRecommendationRequest)((Object)GetRightsizingRecommendationPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

