/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalysisType {
    MAX_SAVINGS("MAX_SAVINGS"),
    CUSTOM_COMMITMENT("CUSTOM_COMMITMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalysisType> VALUE_MAP;
    private final String value;

    private AnalysisType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisType> knownValues() {
        EnumSet<AnalysisType> knownValues = EnumSet.allOf(AnalysisType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalysisType.class, AnalysisType::toString);
    }
}

