/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTag;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse;

public class ListCostAllocationTagsPublisher
implements SdkPublisher<ListCostAllocationTagsResponse> {
    private final CostExplorerAsyncClient client;
    private final ListCostAllocationTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCostAllocationTagsPublisher(CostExplorerAsyncClient client, ListCostAllocationTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCostAllocationTagsPublisher(CostExplorerAsyncClient client, ListCostAllocationTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCostAllocationTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCostAllocationTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CostAllocationTag> costAllocationTags() {
        Function<ListCostAllocationTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.costAllocationTags() != null) {
                return response.costAllocationTags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCostAllocationTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCostAllocationTagsResponseFetcher
    implements AsyncPageFetcher<ListCostAllocationTagsResponse> {
        private ListCostAllocationTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostAllocationTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCostAllocationTagsResponse> nextPage(ListCostAllocationTagsResponse previousPage) {
            if (previousPage == null) {
                return ListCostAllocationTagsPublisher.this.client.listCostAllocationTags(ListCostAllocationTagsPublisher.this.firstRequest);
            }
            return ListCostAllocationTagsPublisher.this.client.listCostAllocationTags((ListCostAllocationTagsRequest)((Object)ListCostAllocationTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

