/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;

public class GetAnomalyMonitorsIterable
implements SdkIterable<GetAnomalyMonitorsResponse> {
    private final CostExplorerClient client;
    private final GetAnomalyMonitorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAnomalyMonitorsIterable(CostExplorerClient client, GetAnomalyMonitorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAnomalyMonitorsResponseFetcher();
    }

    public Iterator<GetAnomalyMonitorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalyMonitor> anomalyMonitors() {
        Function<GetAnomalyMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyMonitors() != null) {
                return response.anomalyMonitors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAnomalyMonitorsResponseFetcher
    implements SyncPageFetcher<GetAnomalyMonitorsResponse> {
        private GetAnomalyMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomalyMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetAnomalyMonitorsResponse nextPage(GetAnomalyMonitorsResponse previousPage) {
            if (previousPage == null) {
                return GetAnomalyMonitorsIterable.this.client.getAnomalyMonitors(GetAnomalyMonitorsIterable.this.firstRequest);
            }
            return GetAnomalyMonitorsIterable.this.client.getAnomalyMonitors((GetAnomalyMonitorsRequest)((Object)GetAnomalyMonitorsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

