/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.CostExplorerServiceClientConfiguration;
import software.amazon.awssdk.services.costexplorer.internal.CostExplorerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.costexplorer.model.AnalysisNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.BackfillLimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.BillingViewHealthStatusException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GenerationExistsException;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetApproximateUsageRecordsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetApproximateUsageRecordsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCommitmentPurchaseAnalysisRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCommitmentPurchaseAnalysisResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.costexplorer.model.StartCommitmentPurchaseAnalysisRequest;
import software.amazon.awssdk.services.costexplorer.model.StartCommitmentPurchaseAnalysisResponse;
import software.amazon.awssdk.services.costexplorer.model.StartCostAllocationTagBackfillRequest;
import software.amazon.awssdk.services.costexplorer.model.StartCostAllocationTagBackfillResponse;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.TagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.TagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.TooManyTagsException;
import software.amazon.awssdk.services.costexplorer.model.UnknownMonitorException;
import software.amazon.awssdk.services.costexplorer.model.UnknownSubscriptionException;
import software.amazon.awssdk.services.costexplorer.model.UnresolvableUsageUnitException;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DescribeCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomaliesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalyMonitorsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalySubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetApproximateUsageRecordsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCommitmentPurchaseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageComparisonsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageWithResourcesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostCategoriesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostComparisonDriversRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetRightsizingRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlanPurchaseRecommendationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetUsageForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCommitmentPurchaseAnalysesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostAllocationTagBackfillHistoryRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostAllocationTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostCategoryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListSavingsPlansPurchaseRecommendationGenerationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ProvideAnomalyFeedbackRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartCommitmentPurchaseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartCostAllocationTagBackfillRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartSavingsPlansPurchaseRecommendationGenerationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostAllocationTagsStatusRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCostExplorerClient
implements CostExplorerClient {
    private static final Logger log = Logger.loggerFor(DefaultCostExplorerClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCostExplorerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Cost_Explorer#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnomalyMonitorResponse createAnomalyMonitor(CreateAnomalyMonitorRequest createAnomalyMonitorRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalyMonitorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, createAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalyMonitor");
            CreateAnomalyMonitorResponse createAnomalyMonitorResponse = (CreateAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createAnomalyMonitor$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnomalySubscriptionResponse createAnomalySubscription(CreateAnomalySubscriptionRequest createAnomalySubscriptionRequest) throws UnknownMonitorException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalySubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, createAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalySubscription");
            CreateAnomalySubscriptionResponse createAnomalySubscriptionResponse = (CreateAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createAnomalySubscription$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCostCategoryDefinitionResponse createCostCategoryDefinition(CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) throws ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCostCategoryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, createCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCostCategoryDefinition");
            CreateCostCategoryDefinitionResponse createCostCategoryDefinitionResponse = (CreateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createCostCategoryDefinition$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalyMonitorResponse deleteAnomalyMonitor(DeleteAnomalyMonitorRequest deleteAnomalyMonitorRequest) throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalyMonitorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, deleteAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyMonitor");
            DeleteAnomalyMonitorResponse deleteAnomalyMonitorResponse = (DeleteAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteAnomalyMonitor$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalySubscriptionResponse deleteAnomalySubscription(DeleteAnomalySubscriptionRequest deleteAnomalySubscriptionRequest) throws LimitExceededException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalySubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, deleteAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalySubscription");
            DeleteAnomalySubscriptionResponse deleteAnomalySubscriptionResponse = (DeleteAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteAnomalySubscription$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCostCategoryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, deleteCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCostCategoryDefinition");
            DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinitionResponse = (DeleteCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteCostCategoryDefinition$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCostCategoryDefinitionResponse describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCostCategoryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, describeCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCostCategoryDefinition");
            DescribeCostCategoryDefinitionResponse describeCostCategoryDefinitionResponse = (DescribeCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$describeCostCategoryDefinition$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomaliesResponse getAnomalies(GetAnomaliesRequest getAnomaliesRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomaliesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomaliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getAnomaliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalies");
            GetAnomaliesResponse getAnomaliesResponse = (GetAnomaliesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAnomaliesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomaliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomaliesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalies$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomalyMonitorsResponse getAnomalyMonitors(GetAnomalyMonitorsRequest getAnomalyMonitorsRequest) throws LimitExceededException, UnknownMonitorException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalyMonitorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomalyMonitorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getAnomalyMonitorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalyMonitors");
            GetAnomalyMonitorsResponse getAnomalyMonitorsResponse = (GetAnomalyMonitorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalyMonitors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAnomalyMonitorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomalyMonitorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomalyMonitorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalyMonitors$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomalySubscriptionsResponse getAnomalySubscriptions(GetAnomalySubscriptionsRequest getAnomalySubscriptionsRequest) throws LimitExceededException, UnknownSubscriptionException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalySubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomalySubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getAnomalySubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalySubscriptions");
            GetAnomalySubscriptionsResponse getAnomalySubscriptionsResponse = (GetAnomalySubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalySubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAnomalySubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomalySubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomalySubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalySubscriptions$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApproximateUsageRecordsResponse getApproximateUsageRecords(GetApproximateUsageRecordsRequest getApproximateUsageRecordsRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApproximateUsageRecordsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApproximateUsageRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getApproximateUsageRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApproximateUsageRecords");
            GetApproximateUsageRecordsResponse getApproximateUsageRecordsResponse = (GetApproximateUsageRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApproximateUsageRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApproximateUsageRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApproximateUsageRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApproximateUsageRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getApproximateUsageRecords$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCommitmentPurchaseAnalysisResponse getCommitmentPurchaseAnalysis(GetCommitmentPurchaseAnalysisRequest getCommitmentPurchaseAnalysisRequest) throws LimitExceededException, AnalysisNotFoundException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommitmentPurchaseAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCommitmentPurchaseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCommitmentPurchaseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommitmentPurchaseAnalysis");
            GetCommitmentPurchaseAnalysisResponse getCommitmentPurchaseAnalysisResponse = (GetCommitmentPurchaseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommitmentPurchaseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCommitmentPurchaseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCommitmentPurchaseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCommitmentPurchaseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCommitmentPurchaseAnalysis$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageResponse getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostAndUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostAndUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsage");
            GetCostAndUsageResponse getCostAndUsageResponse = (GetCostAndUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostAndUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostAndUsage$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageComparisonsResponse getCostAndUsageComparisons(GetCostAndUsageComparisonsRequest getCostAndUsageComparisonsRequest) throws DataUnavailableException, InvalidNextTokenException, LimitExceededException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageComparisonsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostAndUsageComparisonsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostAndUsageComparisonsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsageComparisons");
            GetCostAndUsageComparisonsResponse getCostAndUsageComparisonsResponse = (GetCostAndUsageComparisonsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsageComparisons").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostAndUsageComparisonsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageComparisonsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageComparisonsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostAndUsageComparisons$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageWithResourcesResponse getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) throws DataUnavailableException, LimitExceededException, BillExpirationException, InvalidNextTokenException, RequestChangedException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageWithResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostAndUsageWithResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostAndUsageWithResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsageWithResources");
            GetCostAndUsageWithResourcesResponse getCostAndUsageWithResourcesResponse = (GetCostAndUsageWithResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsageWithResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostAndUsageWithResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageWithResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageWithResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostAndUsageWithResources$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostCategoriesResponse getCostCategories(GetCostCategoriesRequest getCostCategoriesRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostCategoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostCategoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostCategories");
            GetCostCategoriesResponse getCostCategoriesResponse = (GetCostCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostCategories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostCategoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostCategories$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostComparisonDriversResponse getCostComparisonDrivers(GetCostComparisonDriversRequest getCostComparisonDriversRequest) throws DataUnavailableException, InvalidNextTokenException, LimitExceededException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostComparisonDriversResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostComparisonDriversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostComparisonDriversRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostComparisonDrivers");
            GetCostComparisonDriversResponse getCostComparisonDriversResponse = (GetCostComparisonDriversResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostComparisonDrivers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostComparisonDriversRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostComparisonDriversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostComparisonDriversResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostComparisonDrivers$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostForecastResponse getCostForecast(GetCostForecastRequest getCostForecastRequest) throws LimitExceededException, DataUnavailableException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostForecastResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getCostForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostForecast");
            GetCostForecastResponse getCostForecastResponse = (GetCostForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCostForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostForecast$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDimensionValuesResponse getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDimensionValuesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDimensionValuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getDimensionValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDimensionValues");
            GetDimensionValuesResponse getDimensionValuesResponse = (GetDimensionValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDimensionValues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDimensionValuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDimensionValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDimensionValuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getDimensionValues$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationCoverageResponse getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationCoverageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getReservationCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationCoverage");
            GetReservationCoverageResponse getReservationCoverageResponse = (GetReservationCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationCoverage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReservationCoverageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationCoverageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationCoverage$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationPurchaseRecommendationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationPurchaseRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getReservationPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationPurchaseRecommendation");
            GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendationResponse = (GetReservationPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationPurchaseRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReservationPurchaseRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationPurchaseRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationPurchaseRecommendation$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationUtilizationResponse getReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationUtilizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationUtilizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getReservationUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationUtilization");
            GetReservationUtilizationResponse getReservationUtilizationResponse = (GetReservationUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationUtilization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReservationUtilizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationUtilizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationUtilization$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRightsizingRecommendationResponse getRightsizingRecommendation(GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRightsizingRecommendationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRightsizingRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getRightsizingRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRightsizingRecommendation");
            GetRightsizingRecommendationResponse getRightsizingRecommendationResponse = (GetRightsizingRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRightsizingRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRightsizingRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRightsizingRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRightsizingRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getRightsizingRecommendation$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlanPurchaseRecommendationDetailsResponse getSavingsPlanPurchaseRecommendationDetails(GetSavingsPlanPurchaseRecommendationDetailsRequest getSavingsPlanPurchaseRecommendationDetailsRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlanPurchaseRecommendationDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlanPurchaseRecommendationDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getSavingsPlanPurchaseRecommendationDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlanPurchaseRecommendationDetails");
            GetSavingsPlanPurchaseRecommendationDetailsResponse getSavingsPlanPurchaseRecommendationDetailsResponse = (GetSavingsPlanPurchaseRecommendationDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlanPurchaseRecommendationDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSavingsPlanPurchaseRecommendationDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlanPurchaseRecommendationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlanPurchaseRecommendationDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlanPurchaseRecommendationDetails$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansCoverageResponse getSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansCoverageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansCoverage");
            GetSavingsPlansCoverageResponse getSavingsPlansCoverageResponse = (GetSavingsPlansCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansCoverage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSavingsPlansCoverageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansCoverageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansCoverage$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansPurchaseRecommendationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansPurchaseRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansPurchaseRecommendation");
            GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendationResponse = (GetSavingsPlansPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansPurchaseRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSavingsPlansPurchaseRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansPurchaseRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansPurchaseRecommendation$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationResponse getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansUtilizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilization");
            GetSavingsPlansUtilizationResponse getSavingsPlansUtilizationResponse = (GetSavingsPlansUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSavingsPlansUtilizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansUtilization$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansUtilizationDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansUtilizationDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilizationDetails");
            GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetailsResponse = (GetSavingsPlansUtilizationDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilizationDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSavingsPlansUtilizationDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansUtilizationDetails$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTags");
            GetTagsResponse getTagsResponse = (GetTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getTags$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageForecastResponse getUsageForecast(GetUsageForecastRequest getUsageForecastRequest) throws LimitExceededException, DataUnavailableException, UnresolvableUsageUnitException, ResourceNotFoundException, BillingViewHealthStatusException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageForecastResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUsageForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, getUsageForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageForecast");
            GetUsageForecastResponse getUsageForecastResponse = (GetUsageForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getUsageForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getUsageForecast$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCommitmentPurchaseAnalysesResponse listCommitmentPurchaseAnalyses(ListCommitmentPurchaseAnalysesRequest listCommitmentPurchaseAnalysesRequest) throws LimitExceededException, InvalidNextTokenException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCommitmentPurchaseAnalysesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCommitmentPurchaseAnalysesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listCommitmentPurchaseAnalysesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCommitmentPurchaseAnalyses");
            ListCommitmentPurchaseAnalysesResponse listCommitmentPurchaseAnalysesResponse = (ListCommitmentPurchaseAnalysesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCommitmentPurchaseAnalyses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCommitmentPurchaseAnalysesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCommitmentPurchaseAnalysesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCommitmentPurchaseAnalysesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listCommitmentPurchaseAnalyses$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCostAllocationTagBackfillHistoryResponse listCostAllocationTagBackfillHistory(ListCostAllocationTagBackfillHistoryRequest listCostAllocationTagBackfillHistoryRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostAllocationTagBackfillHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostAllocationTagBackfillHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listCostAllocationTagBackfillHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostAllocationTagBackfillHistory");
            ListCostAllocationTagBackfillHistoryResponse listCostAllocationTagBackfillHistoryResponse = (ListCostAllocationTagBackfillHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostAllocationTagBackfillHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCostAllocationTagBackfillHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCostAllocationTagBackfillHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCostAllocationTagBackfillHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listCostAllocationTagBackfillHistory$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCostAllocationTagsResponse listCostAllocationTags(ListCostAllocationTagsRequest listCostAllocationTagsRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostAllocationTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostAllocationTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listCostAllocationTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostAllocationTags");
            ListCostAllocationTagsResponse listCostAllocationTagsResponse = (ListCostAllocationTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostAllocationTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCostAllocationTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCostAllocationTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCostAllocationTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listCostAllocationTags$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCostCategoryDefinitionsResponse listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostCategoryDefinitionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostCategoryDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listCostCategoryDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostCategoryDefinitions");
            ListCostCategoryDefinitionsResponse listCostCategoryDefinitionsResponse = (ListCostCategoryDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostCategoryDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCostCategoryDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCostCategoryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCostCategoryDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listCostCategoryDefinitions$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSavingsPlansPurchaseRecommendationGenerationResponse listSavingsPlansPurchaseRecommendationGeneration(ListSavingsPlansPurchaseRecommendationGenerationRequest listSavingsPlansPurchaseRecommendationGenerationRequest) throws LimitExceededException, InvalidNextTokenException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSavingsPlansPurchaseRecommendationGenerationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSavingsPlansPurchaseRecommendationGenerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listSavingsPlansPurchaseRecommendationGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSavingsPlansPurchaseRecommendationGeneration");
            ListSavingsPlansPurchaseRecommendationGenerationResponse listSavingsPlansPurchaseRecommendationGenerationResponse = (ListSavingsPlansPurchaseRecommendationGenerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSavingsPlansPurchaseRecommendationGeneration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSavingsPlansPurchaseRecommendationGenerationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSavingsPlansPurchaseRecommendationGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSavingsPlansPurchaseRecommendationGenerationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listSavingsPlansPurchaseRecommendationGeneration$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listTagsForResource$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvideAnomalyFeedbackResponse provideAnomalyFeedback(ProvideAnomalyFeedbackRequest provideAnomalyFeedbackRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvideAnomalyFeedbackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)provideAnomalyFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, provideAnomalyFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvideAnomalyFeedback");
            ProvideAnomalyFeedbackResponse provideAnomalyFeedbackResponse = (ProvideAnomalyFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvideAnomalyFeedback").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)provideAnomalyFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ProvideAnomalyFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provideAnomalyFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$provideAnomalyFeedback$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCommitmentPurchaseAnalysisResponse startCommitmentPurchaseAnalysis(StartCommitmentPurchaseAnalysisRequest startCommitmentPurchaseAnalysisRequest) throws LimitExceededException, ServiceQuotaExceededException, DataUnavailableException, GenerationExistsException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCommitmentPurchaseAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCommitmentPurchaseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, startCommitmentPurchaseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCommitmentPurchaseAnalysis");
            StartCommitmentPurchaseAnalysisResponse startCommitmentPurchaseAnalysisResponse = (StartCommitmentPurchaseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCommitmentPurchaseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startCommitmentPurchaseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCommitmentPurchaseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCommitmentPurchaseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$startCommitmentPurchaseAnalysis$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCostAllocationTagBackfillResponse startCostAllocationTagBackfill(StartCostAllocationTagBackfillRequest startCostAllocationTagBackfillRequest) throws LimitExceededException, BackfillLimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCostAllocationTagBackfillResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCostAllocationTagBackfillRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, startCostAllocationTagBackfillRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCostAllocationTagBackfill");
            StartCostAllocationTagBackfillResponse startCostAllocationTagBackfillResponse = (StartCostAllocationTagBackfillResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCostAllocationTagBackfill").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startCostAllocationTagBackfillRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCostAllocationTagBackfillRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCostAllocationTagBackfillResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$startCostAllocationTagBackfill$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSavingsPlansPurchaseRecommendationGenerationResponse startSavingsPlansPurchaseRecommendationGeneration(StartSavingsPlansPurchaseRecommendationGenerationRequest startSavingsPlansPurchaseRecommendationGenerationRequest) throws LimitExceededException, ServiceQuotaExceededException, GenerationExistsException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSavingsPlansPurchaseRecommendationGenerationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSavingsPlansPurchaseRecommendationGenerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, startSavingsPlansPurchaseRecommendationGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSavingsPlansPurchaseRecommendationGeneration");
            StartSavingsPlansPurchaseRecommendationGenerationResponse startSavingsPlansPurchaseRecommendationGenerationResponse = (StartSavingsPlansPurchaseRecommendationGenerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSavingsPlansPurchaseRecommendationGeneration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSavingsPlansPurchaseRecommendationGenerationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSavingsPlansPurchaseRecommendationGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSavingsPlansPurchaseRecommendationGenerationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$startSavingsPlansPurchaseRecommendationGeneration$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, TooManyTagsException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$tagResource$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$untagResource$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnomalyMonitorResponse updateAnomalyMonitor(UpdateAnomalyMonitorRequest updateAnomalyMonitorRequest) throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalyMonitorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, updateAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalyMonitor");
            UpdateAnomalyMonitorResponse updateAnomalyMonitorResponse = (UpdateAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateAnomalyMonitor$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnomalySubscriptionResponse updateAnomalySubscription(UpdateAnomalySubscriptionRequest updateAnomalySubscriptionRequest) throws LimitExceededException, UnknownMonitorException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalySubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, updateAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalySubscription");
            UpdateAnomalySubscriptionResponse updateAnomalySubscriptionResponse = (UpdateAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateAnomalySubscription$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCostAllocationTagsStatusResponse updateCostAllocationTagsStatus(UpdateCostAllocationTagsStatusRequest updateCostAllocationTagsStatusRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostAllocationTagsStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCostAllocationTagsStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, updateCostAllocationTagsStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostAllocationTagsStatus");
            UpdateCostAllocationTagsStatusResponse updateCostAllocationTagsStatusResponse = (UpdateCostAllocationTagsStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostAllocationTagsStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCostAllocationTagsStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCostAllocationTagsStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCostAllocationTagsStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateCostAllocationTagsStatus$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCostCategoryDefinitionResponse updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostCategoryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "GenerationExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                }
                case "UnresolvableUsageUnitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                }
                case "UnknownSubscriptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                }
                case "RequestChangedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                }
                case "DataUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "BackfillLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnknownMonitorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                }
                case "AnalysisNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "BillingViewHealthStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillingViewHealthStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillingViewHealthStatusException::builder).build());
                }
                case "BillExpirationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(clientConfiguration, updateCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostCategoryDefinition");
            UpdateCostCategoryDefinitionResponse updateCostCategoryDefinitionResponse = (UpdateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateCostCategoryDefinition$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ce";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CostExplorerServiceClientConfigurationBuilder serviceConfigBuilder = new CostExplorerServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CostExplorerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CostExplorerServiceClientConfiguration serviceClientConfiguration() {
        return new CostExplorerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCostCategoryDefinition$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCostAllocationTagsStatus$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalySubscription$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalyMonitor$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSavingsPlansPurchaseRecommendationGeneration$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCostAllocationTagBackfill$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCommitmentPurchaseAnalysis$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provideAnomalyFeedback$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSavingsPlansPurchaseRecommendationGeneration$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostCategoryDefinitions$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostAllocationTags$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostAllocationTagBackfillHistory$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCommitmentPurchaseAnalyses$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsageForecast$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTags$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilizationDetails$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilization$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansPurchaseRecommendation$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansCoverage$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlanPurchaseRecommendationDetails$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRightsizingRecommendation$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationUtilization$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationPurchaseRecommendation$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationCoverage$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDimensionValues$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostForecast$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostComparisonDrivers$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostCategories$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsageWithResources$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsageComparisons$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsage$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommitmentPurchaseAnalysis$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApproximateUsageRecords$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalySubscriptions$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalyMonitors$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalies$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCostCategoryDefinition$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCostCategoryDefinition$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalySubscription$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyMonitor$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCostCategoryDefinition$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalySubscription$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalyMonitor$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

