/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationAggregates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationAggregates> {
    private static final SdkField<String> UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtilizationPercentage").getter(ReservationAggregates.getter(ReservationAggregates::utilizationPercentage)).setter(ReservationAggregates.setter(Builder::utilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentage").build()}).build();
    private static final SdkField<String> UTILIZATION_PERCENTAGE_IN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtilizationPercentageInUnits").getter(ReservationAggregates.getter(ReservationAggregates::utilizationPercentageInUnits)).setter(ReservationAggregates.setter(Builder::utilizationPercentageInUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationPercentageInUnits").build()}).build();
    private static final SdkField<String> PURCHASED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchasedHours").getter(ReservationAggregates.getter(ReservationAggregates::purchasedHours)).setter(ReservationAggregates.setter(Builder::purchasedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchasedHours").build()}).build();
    private static final SdkField<String> PURCHASED_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchasedUnits").getter(ReservationAggregates.getter(ReservationAggregates::purchasedUnits)).setter(ReservationAggregates.setter(Builder::purchasedUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchasedUnits").build()}).build();
    private static final SdkField<String> TOTAL_ACTUAL_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalActualHours").getter(ReservationAggregates.getter(ReservationAggregates::totalActualHours)).setter(ReservationAggregates.setter(Builder::totalActualHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActualHours").build()}).build();
    private static final SdkField<String> TOTAL_ACTUAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalActualUnits").getter(ReservationAggregates.getter(ReservationAggregates::totalActualUnits)).setter(ReservationAggregates.setter(Builder::totalActualUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActualUnits").build()}).build();
    private static final SdkField<String> UNUSED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedHours").getter(ReservationAggregates.getter(ReservationAggregates::unusedHours)).setter(ReservationAggregates.setter(Builder::unusedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedHours").build()}).build();
    private static final SdkField<String> UNUSED_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedUnits").getter(ReservationAggregates.getter(ReservationAggregates::unusedUnits)).setter(ReservationAggregates.setter(Builder::unusedUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedUnits").build()}).build();
    private static final SdkField<String> ON_DEMAND_COST_OF_RI_HOURS_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnDemandCostOfRIHoursUsed").getter(ReservationAggregates.getter(ReservationAggregates::onDemandCostOfRIHoursUsed)).setter(ReservationAggregates.setter(Builder::onDemandCostOfRIHoursUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCostOfRIHoursUsed").build()}).build();
    private static final SdkField<String> NET_RI_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetRISavings").getter(ReservationAggregates.getter(ReservationAggregates::netRISavings)).setter(ReservationAggregates.setter(Builder::netRISavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetRISavings").build()}).build();
    private static final SdkField<String> TOTAL_POTENTIAL_RI_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalPotentialRISavings").getter(ReservationAggregates.getter(ReservationAggregates::totalPotentialRISavings)).setter(ReservationAggregates.setter(Builder::totalPotentialRISavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPotentialRISavings").build()}).build();
    private static final SdkField<String> AMORTIZED_UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmortizedUpfrontFee").getter(ReservationAggregates.getter(ReservationAggregates::amortizedUpfrontFee)).setter(ReservationAggregates.setter(Builder::amortizedUpfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedUpfrontFee").build()}).build();
    private static final SdkField<String> AMORTIZED_RECURRING_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmortizedRecurringFee").getter(ReservationAggregates.getter(ReservationAggregates::amortizedRecurringFee)).setter(ReservationAggregates.setter(Builder::amortizedRecurringFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedRecurringFee").build()}).build();
    private static final SdkField<String> TOTAL_AMORTIZED_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmortizedFee").getter(ReservationAggregates.getter(ReservationAggregates::totalAmortizedFee)).setter(ReservationAggregates.setter(Builder::totalAmortizedFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmortizedFee").build()}).build();
    private static final SdkField<String> RI_COST_FOR_UNUSED_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RICostForUnusedHours").getter(ReservationAggregates.getter(ReservationAggregates::riCostForUnusedHours)).setter(ReservationAggregates.setter(Builder::riCostForUnusedHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RICostForUnusedHours").build()}).build();
    private static final SdkField<String> REALIZED_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RealizedSavings").getter(ReservationAggregates.getter(ReservationAggregates::realizedSavings)).setter(ReservationAggregates.setter(Builder::realizedSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealizedSavings").build()}).build();
    private static final SdkField<String> UNREALIZED_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnrealizedSavings").getter(ReservationAggregates.getter(ReservationAggregates::unrealizedSavings)).setter(ReservationAggregates.setter(Builder::unrealizedSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnrealizedSavings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATION_PERCENTAGE_FIELD, UTILIZATION_PERCENTAGE_IN_UNITS_FIELD, PURCHASED_HOURS_FIELD, PURCHASED_UNITS_FIELD, TOTAL_ACTUAL_HOURS_FIELD, TOTAL_ACTUAL_UNITS_FIELD, UNUSED_HOURS_FIELD, UNUSED_UNITS_FIELD, ON_DEMAND_COST_OF_RI_HOURS_USED_FIELD, NET_RI_SAVINGS_FIELD, TOTAL_POTENTIAL_RI_SAVINGS_FIELD, AMORTIZED_UPFRONT_FEE_FIELD, AMORTIZED_RECURRING_FEE_FIELD, TOTAL_AMORTIZED_FEE_FIELD, RI_COST_FOR_UNUSED_HOURS_FIELD, REALIZED_SAVINGS_FIELD, UNREALIZED_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationAggregates.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String utilizationPercentage;
    private final String utilizationPercentageInUnits;
    private final String purchasedHours;
    private final String purchasedUnits;
    private final String totalActualHours;
    private final String totalActualUnits;
    private final String unusedHours;
    private final String unusedUnits;
    private final String onDemandCostOfRIHoursUsed;
    private final String netRISavings;
    private final String totalPotentialRISavings;
    private final String amortizedUpfrontFee;
    private final String amortizedRecurringFee;
    private final String totalAmortizedFee;
    private final String riCostForUnusedHours;
    private final String realizedSavings;
    private final String unrealizedSavings;

    private ReservationAggregates(BuilderImpl builder) {
        this.utilizationPercentage = builder.utilizationPercentage;
        this.utilizationPercentageInUnits = builder.utilizationPercentageInUnits;
        this.purchasedHours = builder.purchasedHours;
        this.purchasedUnits = builder.purchasedUnits;
        this.totalActualHours = builder.totalActualHours;
        this.totalActualUnits = builder.totalActualUnits;
        this.unusedHours = builder.unusedHours;
        this.unusedUnits = builder.unusedUnits;
        this.onDemandCostOfRIHoursUsed = builder.onDemandCostOfRIHoursUsed;
        this.netRISavings = builder.netRISavings;
        this.totalPotentialRISavings = builder.totalPotentialRISavings;
        this.amortizedUpfrontFee = builder.amortizedUpfrontFee;
        this.amortizedRecurringFee = builder.amortizedRecurringFee;
        this.totalAmortizedFee = builder.totalAmortizedFee;
        this.riCostForUnusedHours = builder.riCostForUnusedHours;
        this.realizedSavings = builder.realizedSavings;
        this.unrealizedSavings = builder.unrealizedSavings;
    }

    public final String utilizationPercentage() {
        return this.utilizationPercentage;
    }

    public final String utilizationPercentageInUnits() {
        return this.utilizationPercentageInUnits;
    }

    public final String purchasedHours() {
        return this.purchasedHours;
    }

    public final String purchasedUnits() {
        return this.purchasedUnits;
    }

    public final String totalActualHours() {
        return this.totalActualHours;
    }

    public final String totalActualUnits() {
        return this.totalActualUnits;
    }

    public final String unusedHours() {
        return this.unusedHours;
    }

    public final String unusedUnits() {
        return this.unusedUnits;
    }

    public final String onDemandCostOfRIHoursUsed() {
        return this.onDemandCostOfRIHoursUsed;
    }

    public final String netRISavings() {
        return this.netRISavings;
    }

    public final String totalPotentialRISavings() {
        return this.totalPotentialRISavings;
    }

    public final String amortizedUpfrontFee() {
        return this.amortizedUpfrontFee;
    }

    public final String amortizedRecurringFee() {
        return this.amortizedRecurringFee;
    }

    public final String totalAmortizedFee() {
        return this.totalAmortizedFee;
    }

    public final String riCostForUnusedHours() {
        return this.riCostForUnusedHours;
    }

    public final String realizedSavings() {
        return this.realizedSavings;
    }

    public final String unrealizedSavings() {
        return this.unrealizedSavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentageInUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandCostOfRIHoursUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.netRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPotentialRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedUpfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedRecurringFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmortizedFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.riCostForUnusedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.realizedSavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.unrealizedSavings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationAggregates)) {
            return false;
        }
        ReservationAggregates other = (ReservationAggregates)obj;
        return Objects.equals(this.utilizationPercentage(), other.utilizationPercentage()) && Objects.equals(this.utilizationPercentageInUnits(), other.utilizationPercentageInUnits()) && Objects.equals(this.purchasedHours(), other.purchasedHours()) && Objects.equals(this.purchasedUnits(), other.purchasedUnits()) && Objects.equals(this.totalActualHours(), other.totalActualHours()) && Objects.equals(this.totalActualUnits(), other.totalActualUnits()) && Objects.equals(this.unusedHours(), other.unusedHours()) && Objects.equals(this.unusedUnits(), other.unusedUnits()) && Objects.equals(this.onDemandCostOfRIHoursUsed(), other.onDemandCostOfRIHoursUsed()) && Objects.equals(this.netRISavings(), other.netRISavings()) && Objects.equals(this.totalPotentialRISavings(), other.totalPotentialRISavings()) && Objects.equals(this.amortizedUpfrontFee(), other.amortizedUpfrontFee()) && Objects.equals(this.amortizedRecurringFee(), other.amortizedRecurringFee()) && Objects.equals(this.totalAmortizedFee(), other.totalAmortizedFee()) && Objects.equals(this.riCostForUnusedHours(), other.riCostForUnusedHours()) && Objects.equals(this.realizedSavings(), other.realizedSavings()) && Objects.equals(this.unrealizedSavings(), other.unrealizedSavings());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationAggregates").add("UtilizationPercentage", (Object)this.utilizationPercentage()).add("UtilizationPercentageInUnits", (Object)this.utilizationPercentageInUnits()).add("PurchasedHours", (Object)this.purchasedHours()).add("PurchasedUnits", (Object)this.purchasedUnits()).add("TotalActualHours", (Object)this.totalActualHours()).add("TotalActualUnits", (Object)this.totalActualUnits()).add("UnusedHours", (Object)this.unusedHours()).add("UnusedUnits", (Object)this.unusedUnits()).add("OnDemandCostOfRIHoursUsed", (Object)this.onDemandCostOfRIHoursUsed()).add("NetRISavings", (Object)this.netRISavings()).add("TotalPotentialRISavings", (Object)this.totalPotentialRISavings()).add("AmortizedUpfrontFee", (Object)this.amortizedUpfrontFee()).add("AmortizedRecurringFee", (Object)this.amortizedRecurringFee()).add("TotalAmortizedFee", (Object)this.totalAmortizedFee()).add("RICostForUnusedHours", (Object)this.riCostForUnusedHours()).add("RealizedSavings", (Object)this.realizedSavings()).add("UnrealizedSavings", (Object)this.unrealizedSavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentage()));
            }
            case "UtilizationPercentageInUnits": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentageInUnits()));
            }
            case "PurchasedHours": {
                return Optional.ofNullable(clazz.cast(this.purchasedHours()));
            }
            case "PurchasedUnits": {
                return Optional.ofNullable(clazz.cast(this.purchasedUnits()));
            }
            case "TotalActualHours": {
                return Optional.ofNullable(clazz.cast(this.totalActualHours()));
            }
            case "TotalActualUnits": {
                return Optional.ofNullable(clazz.cast(this.totalActualUnits()));
            }
            case "UnusedHours": {
                return Optional.ofNullable(clazz.cast(this.unusedHours()));
            }
            case "UnusedUnits": {
                return Optional.ofNullable(clazz.cast(this.unusedUnits()));
            }
            case "OnDemandCostOfRIHoursUsed": {
                return Optional.ofNullable(clazz.cast(this.onDemandCostOfRIHoursUsed()));
            }
            case "NetRISavings": {
                return Optional.ofNullable(clazz.cast(this.netRISavings()));
            }
            case "TotalPotentialRISavings": {
                return Optional.ofNullable(clazz.cast(this.totalPotentialRISavings()));
            }
            case "AmortizedUpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedUpfrontFee()));
            }
            case "AmortizedRecurringFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedRecurringFee()));
            }
            case "TotalAmortizedFee": {
                return Optional.ofNullable(clazz.cast(this.totalAmortizedFee()));
            }
            case "RICostForUnusedHours": {
                return Optional.ofNullable(clazz.cast(this.riCostForUnusedHours()));
            }
            case "RealizedSavings": {
                return Optional.ofNullable(clazz.cast(this.realizedSavings()));
            }
            case "UnrealizedSavings": {
                return Optional.ofNullable(clazz.cast(this.unrealizedSavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UtilizationPercentage", UTILIZATION_PERCENTAGE_FIELD);
        map.put("UtilizationPercentageInUnits", UTILIZATION_PERCENTAGE_IN_UNITS_FIELD);
        map.put("PurchasedHours", PURCHASED_HOURS_FIELD);
        map.put("PurchasedUnits", PURCHASED_UNITS_FIELD);
        map.put("TotalActualHours", TOTAL_ACTUAL_HOURS_FIELD);
        map.put("TotalActualUnits", TOTAL_ACTUAL_UNITS_FIELD);
        map.put("UnusedHours", UNUSED_HOURS_FIELD);
        map.put("UnusedUnits", UNUSED_UNITS_FIELD);
        map.put("OnDemandCostOfRIHoursUsed", ON_DEMAND_COST_OF_RI_HOURS_USED_FIELD);
        map.put("NetRISavings", NET_RI_SAVINGS_FIELD);
        map.put("TotalPotentialRISavings", TOTAL_POTENTIAL_RI_SAVINGS_FIELD);
        map.put("AmortizedUpfrontFee", AMORTIZED_UPFRONT_FEE_FIELD);
        map.put("AmortizedRecurringFee", AMORTIZED_RECURRING_FEE_FIELD);
        map.put("TotalAmortizedFee", TOTAL_AMORTIZED_FEE_FIELD);
        map.put("RICostForUnusedHours", RI_COST_FOR_UNUSED_HOURS_FIELD);
        map.put("RealizedSavings", REALIZED_SAVINGS_FIELD);
        map.put("UnrealizedSavings", UNREALIZED_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationAggregates, T> g) {
        return obj -> g.apply((ReservationAggregates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String utilizationPercentage;
        private String utilizationPercentageInUnits;
        private String purchasedHours;
        private String purchasedUnits;
        private String totalActualHours;
        private String totalActualUnits;
        private String unusedHours;
        private String unusedUnits;
        private String onDemandCostOfRIHoursUsed;
        private String netRISavings;
        private String totalPotentialRISavings;
        private String amortizedUpfrontFee;
        private String amortizedRecurringFee;
        private String totalAmortizedFee;
        private String riCostForUnusedHours;
        private String realizedSavings;
        private String unrealizedSavings;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationAggregates model) {
            this.utilizationPercentage(model.utilizationPercentage);
            this.utilizationPercentageInUnits(model.utilizationPercentageInUnits);
            this.purchasedHours(model.purchasedHours);
            this.purchasedUnits(model.purchasedUnits);
            this.totalActualHours(model.totalActualHours);
            this.totalActualUnits(model.totalActualUnits);
            this.unusedHours(model.unusedHours);
            this.unusedUnits(model.unusedUnits);
            this.onDemandCostOfRIHoursUsed(model.onDemandCostOfRIHoursUsed);
            this.netRISavings(model.netRISavings);
            this.totalPotentialRISavings(model.totalPotentialRISavings);
            this.amortizedUpfrontFee(model.amortizedUpfrontFee);
            this.amortizedRecurringFee(model.amortizedRecurringFee);
            this.totalAmortizedFee(model.totalAmortizedFee);
            this.riCostForUnusedHours(model.riCostForUnusedHours);
            this.realizedSavings(model.realizedSavings);
            this.unrealizedSavings(model.unrealizedSavings);
        }

        public final String getUtilizationPercentage() {
            return this.utilizationPercentage;
        }

        public final void setUtilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
        }

        @Override
        public final Builder utilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
            return this;
        }

        public final String getUtilizationPercentageInUnits() {
            return this.utilizationPercentageInUnits;
        }

        public final void setUtilizationPercentageInUnits(String utilizationPercentageInUnits) {
            this.utilizationPercentageInUnits = utilizationPercentageInUnits;
        }

        @Override
        public final Builder utilizationPercentageInUnits(String utilizationPercentageInUnits) {
            this.utilizationPercentageInUnits = utilizationPercentageInUnits;
            return this;
        }

        public final String getPurchasedHours() {
            return this.purchasedHours;
        }

        public final void setPurchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
        }

        @Override
        public final Builder purchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
            return this;
        }

        public final String getPurchasedUnits() {
            return this.purchasedUnits;
        }

        public final void setPurchasedUnits(String purchasedUnits) {
            this.purchasedUnits = purchasedUnits;
        }

        @Override
        public final Builder purchasedUnits(String purchasedUnits) {
            this.purchasedUnits = purchasedUnits;
            return this;
        }

        public final String getTotalActualHours() {
            return this.totalActualHours;
        }

        public final void setTotalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
        }

        @Override
        public final Builder totalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
            return this;
        }

        public final String getTotalActualUnits() {
            return this.totalActualUnits;
        }

        public final void setTotalActualUnits(String totalActualUnits) {
            this.totalActualUnits = totalActualUnits;
        }

        @Override
        public final Builder totalActualUnits(String totalActualUnits) {
            this.totalActualUnits = totalActualUnits;
            return this;
        }

        public final String getUnusedHours() {
            return this.unusedHours;
        }

        public final void setUnusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
        }

        @Override
        public final Builder unusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
            return this;
        }

        public final String getUnusedUnits() {
            return this.unusedUnits;
        }

        public final void setUnusedUnits(String unusedUnits) {
            this.unusedUnits = unusedUnits;
        }

        @Override
        public final Builder unusedUnits(String unusedUnits) {
            this.unusedUnits = unusedUnits;
            return this;
        }

        public final String getOnDemandCostOfRIHoursUsed() {
            return this.onDemandCostOfRIHoursUsed;
        }

        public final void setOnDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
        }

        @Override
        public final Builder onDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
            return this;
        }

        public final String getNetRISavings() {
            return this.netRISavings;
        }

        public final void setNetRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
        }

        @Override
        public final Builder netRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
            return this;
        }

        public final String getTotalPotentialRISavings() {
            return this.totalPotentialRISavings;
        }

        public final void setTotalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
        }

        @Override
        public final Builder totalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
            return this;
        }

        public final String getAmortizedUpfrontFee() {
            return this.amortizedUpfrontFee;
        }

        public final void setAmortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
        }

        @Override
        public final Builder amortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
            return this;
        }

        public final String getAmortizedRecurringFee() {
            return this.amortizedRecurringFee;
        }

        public final void setAmortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
        }

        @Override
        public final Builder amortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
            return this;
        }

        public final String getTotalAmortizedFee() {
            return this.totalAmortizedFee;
        }

        public final void setTotalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
        }

        @Override
        public final Builder totalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
            return this;
        }

        public final String getRiCostForUnusedHours() {
            return this.riCostForUnusedHours;
        }

        public final void setRiCostForUnusedHours(String riCostForUnusedHours) {
            this.riCostForUnusedHours = riCostForUnusedHours;
        }

        @Override
        public final Builder riCostForUnusedHours(String riCostForUnusedHours) {
            this.riCostForUnusedHours = riCostForUnusedHours;
            return this;
        }

        public final String getRealizedSavings() {
            return this.realizedSavings;
        }

        public final void setRealizedSavings(String realizedSavings) {
            this.realizedSavings = realizedSavings;
        }

        @Override
        public final Builder realizedSavings(String realizedSavings) {
            this.realizedSavings = realizedSavings;
            return this;
        }

        public final String getUnrealizedSavings() {
            return this.unrealizedSavings;
        }

        public final void setUnrealizedSavings(String unrealizedSavings) {
            this.unrealizedSavings = unrealizedSavings;
        }

        @Override
        public final Builder unrealizedSavings(String unrealizedSavings) {
            this.unrealizedSavings = unrealizedSavings;
            return this;
        }

        public ReservationAggregates build() {
            return new ReservationAggregates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationAggregates> {
        public Builder utilizationPercentage(String var1);

        public Builder utilizationPercentageInUnits(String var1);

        public Builder purchasedHours(String var1);

        public Builder purchasedUnits(String var1);

        public Builder totalActualHours(String var1);

        public Builder totalActualUnits(String var1);

        public Builder unusedHours(String var1);

        public Builder unusedUnits(String var1);

        public Builder onDemandCostOfRIHoursUsed(String var1);

        public Builder netRISavings(String var1);

        public Builder totalPotentialRISavings(String var1);

        public Builder amortizedUpfrontFee(String var1);

        public Builder amortizedRecurringFee(String var1);

        public Builder totalAmortizedFee(String var1);

        public Builder riCostForUnusedHours(String var1);

        public Builder realizedSavings(String var1);

        public Builder unrealizedSavings(String var1);
    }
}

